/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Modifier;
import org.checkerframework.afu.annotator.Main;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.find.IsSigMethodCriterion;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InMethodCriterion
implements Criterion {
    public final String name;
    private final IsSigMethodCriterion sigMethodCriterion;

    InMethodCriterion(String name) {
        this.name = name;
        this.sigMethodCriterion = new IsSigMethodCriterion(name);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_METHOD;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy(%s); this=%s%n", Main.leafString(path), this.toString());
        boolean inDecl = false;
        boolean staticDecl = false;
        TreePath childPath = null;
        do {
            Tree leaf;
            if ((leaf = path.getLeaf()) instanceof MethodTree) {
                boolean b = this.sigMethodCriterion.isSatisfiedBy(path);
                Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy => %s%n", b);
                return b;
            }
            if (leaf instanceof VariableTree) {
                boolean found;
                VariableTree varDecl = (VariableTree)leaf;
                boolean bl = found = childPath != null && childPath.getLeaf() == varDecl.getInitializer();
                if (found) {
                    inDecl = true;
                    ModifiersTree mods = varDecl.getModifiers();
                    staticDecl = mods.getFlags().contains((Object)Modifier.STATIC);
                }
            }
            childPath = path;
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        boolean result = inDecl && (staticDecl ? "<clinit>()V" : "<init>()V").equals(this.name);
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy => %s%n", result);
        return result;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    public String toString() {
        return "in method '" + this.name + "'";
    }
}

