/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;

public class AElement
implements Cloneable {
    public final Set<Annotation> tlAnnotationsHere = new LinkedHashSet<Annotation>();
    public final ATypeElement type;
    public Object description;

    AElement(Object description) {
        this(description, false);
    }

    AElement(Object description, boolean hasType) {
        this(description, hasType ? new ATypeElement("type of " + description) : null);
    }

    AElement(Object description, ATypeElement type) {
        this.description = description;
        this.type = type;
    }

    AElement(AElement elem) {
        this(elem, elem.type);
    }

    AElement(AElement elem, ATypeElement type) {
        this(elem.description, type == null ? null : type.clone());
        this.tlAnnotationsHere.addAll(elem.tlAnnotationsHere);
    }

    AElement(AElement elem, Object description) {
        this(description, elem.type == null ? null : elem.type.clone());
        this.tlAnnotationsHere.addAll(elem.tlAnnotationsHere);
    }

    public AElement clone() {
        return new AElement(this);
    }

    public boolean equals(Object o) {
        return o instanceof AElement && ((AElement)o).equals(this);
    }

    public boolean equals(AElement o) {
        return o.equalsElement(this);
    }

    final boolean equalsElement(AElement o) {
        return o.tlAnnotationsHere.equals(this.tlAnnotationsHere) && (o.type == null ? this.type == null : o.type.equals(this.type));
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.tlAnnotationsHere.hashCode() + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean isEmpty() {
        return this.tlAnnotationsHere.isEmpty() && (this.type == null || this.type.isEmpty());
    }

    public void prune() {
        this.type.prune();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AElement: ");
        sb.append(this.description);
        sb.append(" : ");
        this.tlAnnotationsHereFormatted(sb);
        if (this.type != null) {
            sb.append(' ');
            sb.append(this.type.toString());
        }
        return sb.toString();
    }

    public Annotation lookup(String name) {
        for (Annotation anno : this.tlAnnotationsHere) {
            if (!anno.def.name.equals(name)) continue;
            return anno;
        }
        return null;
    }

    public void tlAnnotationsHereFormatted(StringBuilder sb) {
        boolean first = true;
        for (Annotation aElement : this.tlAnnotationsHere) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(aElement.toString());
        }
    }

    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitElement(this, t);
    }

    static <K> VivifyingMap<K, AElement> newVivifyingLHMap_AE() {
        return new VivifyingMap<K, AElement>((Map)new LinkedHashMap()){

            @Override
            public AElement createValueFor(K k) {
                return new AElement(k);
            }

            @Override
            public boolean isEmptyValue(AElement v) {
                return v.isEmpty();
            }
        };
    }

    static <K> VivifyingMap<K, AElement> newVivifyingLHMap_AET() {
        return new VivifyingMap<K, AElement>((Map)new LinkedHashMap()){

            @Override
            public AElement createValueFor(K k) {
                return new AElement(k, true);
            }

            @Override
            public boolean isEmptyValue(AElement v) {
                return v.isEmpty();
            }
        };
    }

    static <K, V extends AElement> void copyMapContents(VivifyingMap<K, V> orig, VivifyingMap<K, V> copy) {
        for (Object key : orig.keySet()) {
            AElement val = (AElement)orig.get(key);
            copy.put(key, val.clone());
        }
    }
}

