/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;
import org.checkerframework.afu.scenelib.el.TypeIndexLocation;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExtImplsLocationCriterion
implements Criterion {
    private final String classname;
    private final Integer index;

    public ExtImplsLocationCriterion(String classname, TypeIndexLocation tyLoc) {
        this.classname = classname;
        this.index = tyLoc.typeIndex;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return false;
        }
        Tree parent = parentPath.getLeaf();
        if (parent == null) {
            return false;
        }
        if (this.index == -1 && leaf.getKind() == Tree.Kind.CLASS) {
            return ((JCTree.JCClassDecl)leaf).getExtendsClause() == null;
        }
        if (TreePathUtil.hasClassKind(parent)) {
            ClassTree ct = (ClassTree)parent;
            if (this.index == -1) {
                boolean foundLeaf;
                Tree ext = ct.getExtendsClause();
                boolean bl = foundLeaf = ext == leaf;
                if (foundLeaf) {
                    return true;
                }
            } else {
                boolean foundLeaf;
                List<? extends Tree> impls = ct.getImplementsClause();
                boolean bl = foundLeaf = this.index < impls.size() && impls.get(this.index) == leaf;
                if (foundLeaf) {
                    return true;
                }
            }
        }
        return this.isSatisfiedBy(parentPath);
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    public Integer getIndex() {
        return this.index;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.EXTIMPLS_LOCATION;
    }

    public String toString() {
        return "ExtImplsLocationCriterion: class " + this.classname + " at type index: " + this.index;
    }
}

