/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class Defaults {
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Double DOUBLE_DEFAULT = 0.0;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Float FLOAT_DEFAULT = Float.valueOf(0.0f);

    private Defaults() {
    }

    @CheckForNull
    public static <T> @Nullable T defaultValue(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Class<T> type) {
        Preconditions.checkNotNull(type);
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (type == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (type == Float.TYPE) {
                return (T)FLOAT_DEFAULT;
            }
            if (type == Double.TYPE) {
                return (T)DOUBLE_DEFAULT;
            }
        }
        return null;
    }
}

