/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io.classfile;

import java.util.Arrays;
import org.checkerframework.afu.scenelib.io.DebugWriter;
import org.checkerframework.org.objectweb.asm.ClassReader;
import org.checkerframework.org.objectweb.asm.ClassVisitor;
import org.checkerframework.org.objectweb.asm.ClassWriter;
import org.checkerframework.org.objectweb.asm.Handle;
import org.checkerframework.org.objectweb.asm.Label;
import org.checkerframework.org.objectweb.asm.MethodVisitor;

public class CodeOffsetAdapter
extends ClassVisitor {
    static final DebugWriter debug = new DebugWriter(false);
    final ClassReader classReader;
    final char[] buffer;
    int methodStart;
    int codeStart;
    int offset;
    int previousOffset;

    public CodeOffsetAdapter(int api, ClassReader classReader) {
        super(api, new ClassWriter(classReader, 0));
        this.classReader = classReader;
        this.buffer = new char[classReader.header];
        this.methodStart = classReader.header + 6;
        this.methodStart += 4 + 2 * classReader.readUnsignedShort(this.methodStart);
        for (int i = classReader.readUnsignedShort(this.methodStart - 2); i > 0; --i) {
            this.methodStart += 8;
            for (int j = classReader.readUnsignedShort(this.methodStart - 2); j > 0; --j) {
                this.methodStart += 6 + classReader.readInt(this.methodStart + 2);
            }
        }
        this.methodStart += 2;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodVisitor(this.api, methodVisitor){
            private int methodEnd;
            {
                String name = CodeOffsetAdapter.this.classReader.readUTF8(CodeOffsetAdapter.this.methodStart + 2, CodeOffsetAdapter.this.buffer);
                String descriptor = CodeOffsetAdapter.this.classReader.readUTF8(CodeOffsetAdapter.this.methodStart + 4, CodeOffsetAdapter.this.buffer);
                int attrCount = CodeOffsetAdapter.this.classReader.readUnsignedShort(CodeOffsetAdapter.this.methodStart + 6);
                debug.debug("visiting %s%s (%d)%n", name, descriptor, CodeOffsetAdapter.this.methodStart);
                debug.debug("%d attributes%n", attrCount);
                CodeOffsetAdapter.this.codeStart = this.methodEnd = CodeOffsetAdapter.this.methodStart + 8;
                if (attrCount > 0) {
                    while (--attrCount >= 0) {
                        String attrName = CodeOffsetAdapter.this.classReader.readUTF8(CodeOffsetAdapter.this.codeStart, CodeOffsetAdapter.this.buffer);
                        debug.debug("attribute %s%n", attrName);
                        if ("Code".equals(attrName)) {
                            CodeOffsetAdapter.this.codeStart += 6;
                            CodeOffsetAdapter.this.offset = CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.classReader.readInt(CodeOffsetAdapter.this.codeStart - 4);
                            CodeOffsetAdapter.this.codeStart += 8;
                            while (--attrCount >= 0) {
                                debug.debug("attribute %s%n", CodeOffsetAdapter.this.classReader.readUTF8(CodeOffsetAdapter.this.offset, CodeOffsetAdapter.this.buffer));
                                CodeOffsetAdapter.this.offset += 6 + CodeOffsetAdapter.this.classReader.readInt(CodeOffsetAdapter.this.offset + 2);
                            }
                            this.methodEnd = CodeOffsetAdapter.this.offset;
                            break;
                        }
                        CodeOffsetAdapter.this.codeStart += 6 + CodeOffsetAdapter.this.classReader.readInt(CodeOffsetAdapter.this.codeStart + 2);
                        this.methodEnd = CodeOffsetAdapter.this.codeStart;
                    }
                }
                CodeOffsetAdapter.this.offset = 0;
                CodeOffsetAdapter.this.previousOffset = -1;
            }

            private int readInt(int i) {
                return CodeOffsetAdapter.this.classReader.readInt(CodeOffsetAdapter.this.codeStart + i);
            }

            @Override
            public void visitLabel(Label label) {
                super.visitLabel(label);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                super.visitFieldInsn(opcode, owner, name, descriptor);
                debug.debug("%d visitFieldInsn(%d, %s, %s, %s)%n", CodeOffsetAdapter.this.offset, opcode, owner, name, descriptor);
                CodeOffsetAdapter.this.advance(3);
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(var, increment);
                debug.debug("%d visitIincInsn(%d, %d)%n", CodeOffsetAdapter.this.offset, var, increment);
                CodeOffsetAdapter.this.advance(3);
            }

            @Override
            public void visitInsn(int opcode) {
                super.visitInsn(opcode);
                debug.debug("%d visitInsn(%d)%n", CodeOffsetAdapter.this.offset, opcode);
                CodeOffsetAdapter.this.advance(1);
            }

            @Override
            public void visitIntInsn(int opcode, int operand) {
                super.visitIntInsn(opcode, operand);
                debug.debug("%d visitIntInsn(%d, %d)%n", CodeOffsetAdapter.this.offset, opcode, operand);
                CodeOffsetAdapter.this.advance(opcode == 17 ? 3 : 2);
            }

            @Override
            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bsm, Object ... bsmArgs) {
                super.visitInvokeDynamicInsn(name, descriptor, bsm, bsmArgs);
                debug.debug("%d visitInvokeDynamicInsn(%s, %s, %s, %s)%n", CodeOffsetAdapter.this.offset, name, descriptor, bsm, Arrays.toString(bsmArgs));
                CodeOffsetAdapter.this.advance(5);
            }

            @Override
            public void visitJumpInsn(int opcode, Label label) {
                super.visitJumpInsn(opcode, label);
                debug.debug("%d visitJumpInsn(%d, %s)%n", CodeOffsetAdapter.this.offset, opcode, label);
                CodeOffsetAdapter.this.advance(CodeOffsetAdapter.this.classReader.readByte(CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset) < 200 ? 3 : 4);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            public void visitLdcInsn(Object cst) {
                super.visitLdcInsn(cst);
                debug.debug("%d visitLdcInsn(%s)%n", CodeOffsetAdapter.this.offset, cst);
                CodeOffsetAdapter.this.advance(CodeOffsetAdapter.this.classReader.readByte(CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset) > 18 ? 3 : 2);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                super.visitLookupSwitchInsn(dflt, keys, labels);
                debug.debug("%d visitLookupSwitchInsn(%s, %s, %s)%n", CodeOffsetAdapter.this.offset, dflt, Arrays.toString(keys), Arrays.toString(labels));
                CodeOffsetAdapter.this.previousOffset = CodeOffsetAdapter.this.offset;
                CodeOffsetAdapter.this.offset += 8 - (CodeOffsetAdapter.this.offset & 3);
                CodeOffsetAdapter.this.offset += 4 + 8 * this.readInt(CodeOffsetAdapter.this.offset);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            @Deprecated
            public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
                super.visitMethodInsn(opcode, owner, name, descriptor);
                debug.debug("%d visitMethodInsn(%d, %s, %s, %s)%n", CodeOffsetAdapter.this.offset, opcode, owner, name, descriptor);
                CodeOffsetAdapter.this.advance(opcode == 185 ? 5 : 3);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                debug.debug("%d visitMethodInsn(%d, %s, %s, %s, %s)%n", CodeOffsetAdapter.this.offset, opcode, owner, name, descriptor, isInterface);
                CodeOffsetAdapter.this.advance(opcode == 185 ? 5 : 3);
            }

            @Override
            public void visitMultiANewArrayInsn(String descriptor, int dims) {
                super.visitMultiANewArrayInsn(descriptor, dims);
                debug.debug("%d visitMultiANewArrayInsn(%s, %d)%n", CodeOffsetAdapter.this.offset, descriptor, dims);
                CodeOffsetAdapter.this.advance(4);
            }

            @Override
            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                super.visitTableSwitchInsn(min, max, dflt, labels);
                debug.debug("%d visitTableSwitchInsn(%d, %d, %s, %s)%n", CodeOffsetAdapter.this.offset, min, max, dflt, Arrays.toString(labels));
                CodeOffsetAdapter.this.previousOffset = CodeOffsetAdapter.this.offset;
                CodeOffsetAdapter.this.offset += 8 - (CodeOffsetAdapter.this.offset & 3);
                CodeOffsetAdapter.this.offset += 4 * (this.readInt(CodeOffsetAdapter.this.offset + 4) - this.readInt(CodeOffsetAdapter.this.offset) + 3);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            public void visitTypeInsn(int opcode, String descriptor) {
                super.visitTypeInsn(opcode, descriptor);
                debug.debug("%d visitTypeInsn(%d, %s)%n", CodeOffsetAdapter.this.offset, opcode, descriptor);
                CodeOffsetAdapter.this.advance(3);
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, var);
                debug.debug("%d visitVarInsn(%d, %d)%n", CodeOffsetAdapter.this.offset, opcode, var);
                CodeOffsetAdapter.this.advance(var < 4 ? 1 : 2);
            }

            @Override
            public void visitEnd() {
                super.visitEnd();
                CodeOffsetAdapter.this.methodStart = this.methodEnd;
            }
        };
    }

    public int getPreviousCodeOffset() {
        return this.previousOffset;
    }

    public int getMethodCodeOffset() {
        return this.offset;
    }

    public int getBytecodeOffset() {
        return this.codeStart + this.offset;
    }

    private void advance(int n) {
        this.previousOffset = this.offset;
        this.offset += n;
    }
}

