/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.org.objectweb.asm.Label;

public final class LocalLocation {
    public final Label[] start;
    public final Label[] end;
    public final int[] index;
    public final @Nullable String variableName;

    public LocalLocation(int index, String variableName) {
        this(new Label[]{new Label()}, new Label[]{new Label()}, new int[]{index}, variableName);
    }

    public LocalLocation(Label[] start, Label[] end, int[] index, String variableName) {
        this.start = start;
        this.end = end;
        this.index = index;
        this.variableName = variableName;
    }

    public LocalLocation(int scopeStart, int scopeLength, int index) {
        Label startLabel = new Label();
        Label endLabel = new Label();
        try {
            Field flagsField = Label.class.getDeclaredField("flags");
            Field bytecodeOffsetField = Label.class.getDeclaredField("bytecodeOffset");
            Field FLAG_RESOLVED_FIELD = Label.class.getDeclaredField("FLAG_RESOLVED");
            flagsField.setAccessible(true);
            bytecodeOffsetField.setAccessible(true);
            FLAG_RESOLVED_FIELD.setAccessible(true);
            short FLAG_RESOLVED = (short)((Integer)FLAG_RESOLVED_FIELD.get(null)).intValue();
            short flags = (Short)flagsField.get(startLabel);
            flags = (short)(flags | FLAG_RESOLVED);
            flagsField.set(startLabel, flags);
            bytecodeOffsetField.set(startLabel, scopeStart);
            flags = (Short)flagsField.get(endLabel);
            flags = (short)(flags | FLAG_RESOLVED);
            flagsField.set(endLabel, flags);
            bytecodeOffsetField.set(endLabel, scopeStart + scopeLength);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        this.start = new Label[]{startLabel};
        this.end = new Label[]{endLabel};
        this.index = new int[]{index};
        this.variableName = null;
    }

    public boolean scopeStartDefined() {
        try {
            this.start[0].getOffset();
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    public int getScopeStart() {
        try {
            return this.start[0].getOffset();
        }
        catch (IllegalStateException e) {
            throw new Error("Labels not resolved: " + Arrays.toString(this.start));
        }
    }

    public int getScopeLength() {
        try {
            return this.end[this.end.length - 1].getOffset() - this.getScopeStart();
        }
        catch (IllegalStateException e) {
            throw new Error("Labels not resolved: " + Arrays.toString(this.start));
        }
    }

    public int getVarIndex() {
        return this.index[0];
    }

    public boolean equals(LocalLocation o) {
        return Arrays.equals(this.start, o.start) && Arrays.equals(this.end, o.end) && Arrays.equals(this.index, o.index) && (this.variableName == null || this.variableName.equals(o.variableName));
    }

    public boolean equals(Object o) {
        return o instanceof LocalLocation && this.equals((LocalLocation)o);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.start), Arrays.hashCode(this.end), Arrays.hashCode(this.index));
    }

    public String toString() {
        return "LocalLocation{start=" + Arrays.toString(this.start) + ", end=" + Arrays.toString(this.end) + ", index=" + Arrays.toString(this.index) + '}';
    }
}

