/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.afu.scenelib.el.ABlock;
import org.checkerframework.afu.scenelib.el.AClass;
import org.checkerframework.afu.scenelib.el.ADeclaration;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AExpression;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.ATypeElementWithType;
import org.checkerframework.afu.scenelib.el.AnnotationDef;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.io.IndexFileParser;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;
import org.checkerframework.com.google.common.collect.ImmutableMap;

public class AScene
implements Cloneable {
    private static boolean checkClones = true;
    public final VivifyingMap<String, AElement> packages = AElement.newVivifyingLHMap_AE();
    public final Map<String, Set<String>> imports = new LinkedHashMap<String, Set<String>>();
    public final VivifyingMap<String, AClass> classes = new VivifyingMap<String, AClass>(new LinkedHashMap()){

        @Override
        public AClass createValueFor(String k) {
            return new AClass(k);
        }

        @Override
        public boolean isEmptyValue(AClass v) {
            return v.isEmpty();
        }
    };
    private static ElementVisitor<Void, AElement> checkVisitor = new ElementVisitor<Void, AElement>(){

        @Override
        public Void visitAnnotationDef(AnnotationDef el, AElement arg) {
            return null;
        }

        @Override
        public Void visitBlock(ABlock el, AElement arg) {
            ABlock b = (ABlock)arg;
            AScene.checkCloneMap(el.locals, b.locals);
            return null;
        }

        @Override
        public Void visitClass(AClass el, AElement arg) {
            AClass c = (AClass)arg;
            AScene.checkCloneMap(el.bounds, c.bounds);
            AScene.checkCloneMap(el.extendsImplements, c.extendsImplements);
            AScene.checkCloneMap(el.fieldInits, c.fieldInits);
            AScene.checkCloneMap(el.fields, c.fields);
            AScene.checkCloneMap(el.instanceInits, c.instanceInits);
            AScene.checkCloneMap(el.methods, c.methods);
            AScene.checkCloneMap(el.staticInits, c.staticInits);
            return this.visitDeclaration((ADeclaration)el, arg);
        }

        @Override
        public Void visitDeclaration(ADeclaration el, AElement arg) {
            ADeclaration d = (ADeclaration)arg;
            AScene.checkCloneMap(el.insertAnnotations, d.insertAnnotations);
            AScene.checkCloneMap(el.insertTypecasts, d.insertTypecasts);
            this.visitElement((AElement)el, arg);
            return null;
        }

        @Override
        public Void visitExpression(AExpression el, AElement arg) {
            if (el == null && arg == null) {
                return null;
            }
            AExpression e = (AExpression)arg;
            AScene.checkStringsEqual(el.id, e.id);
            AScene.checkCloneMap(el.calls, e.calls);
            AScene.checkCloneMap(el.funs, e.funs);
            AScene.checkCloneMap(el.instanceofs, e.instanceofs);
            AScene.checkCloneMap(el.news, e.news);
            AScene.checkCloneMap(el.refs, e.refs);
            AScene.checkCloneMap(el.typecasts, e.typecasts);
            this.visitElement((AElement)el, arg);
            return null;
        }

        @Override
        public Void visitField(AField el, AElement arg) {
            AField f = (AField)arg;
            this.visitExpression(el.init, f.init);
            this.visitDeclaration((ADeclaration)el, arg);
            return null;
        }

        @Override
        public Void visitMethod(AMethod el, AElement arg) {
            AMethod m = (AMethod)arg;
            AScene.checkStringsEqual(el.methodSignature, m.methodSignature);
            AScene.checkCloneMap(el.bounds, m.bounds);
            this.visitTypeElement(el.returnType, m.returnType);
            this.visitField(el.receiver, m.receiver);
            AScene.checkCloneMap(el.parameters, m.parameters);
            AScene.checkCloneMap(el.throwsException, m.throwsException);
            AScene.checkCloneMap(el.preconditions, m.preconditions);
            AScene.checkCloneMap(el.postconditions, m.postconditions);
            this.visitBlock(el.body, m.body);
            return null;
        }

        @Override
        public Void visitTypeElement(ATypeElement el, AElement arg) {
            if (el == null && arg == null) {
                return null;
            }
            ATypeElement t = (ATypeElement)arg;
            AScene.checkDescriptionsEqual(el.description, t.description);
            AScene.checkCloneMap(el.innerTypes, t.innerTypes);
            return null;
        }

        @Override
        public Void visitTypeElementWithType(ATypeElementWithType el, AElement arg) {
            ATypeElementWithType t = (ATypeElementWithType)arg;
            AScene.checkCloneNotReferenceEqual(el.getType(), t.getType());
            this.visitTypeElement((ATypeElement)el, arg);
            return null;
        }

        @Override
        public Void visitElement(AElement el, AElement arg) {
            AScene.checkDescriptionsEqual(el.description, arg.description);
            AScene.checkCloneSet(el.tlAnnotationsHere, arg.tlAnnotationsHere);
            this.visitTypeElement(el.type, arg.type);
            return null;
        }
    };

    public AScene() {
    }

    public AScene(AScene scene) {
        for (String key : scene.packages.keySet()) {
            AElement val = (AElement)scene.packages.get(key);
            this.packages.put(key, val.clone());
        }
        for (String key : scene.imports.keySet()) {
            Set<String> value = scene.imports.get(key);
            LinkedHashSet<String> copy = new LinkedHashSet<String>();
            copy.addAll(value);
            this.imports.put(key, copy);
        }
        for (String key : scene.classes.keySet()) {
            AClass clazz = (AClass)scene.classes.get(key);
            this.classes.put(key, clazz.clone());
        }
        if (checkClones) {
            AScene.checkClone(this, scene);
        }
    }

    public AScene clone() {
        return new AScene(this);
    }

    public boolean equals(Object o) {
        return o instanceof AScene && ((AScene)o).equals(this);
    }

    public boolean equals(AScene o) {
        return o.classes.equals(this.classes) && o.packages.equals(this.packages);
    }

    public int hashCode() {
        return this.classes.hashCode() + this.packages.hashCode();
    }

    public Map<String, AClass> getClasses() {
        return ImmutableMap.copyOf(this.classes);
    }

    public boolean isEmpty() {
        return this.classes.isEmpty() && this.packages.isEmpty();
    }

    public void prune() {
        this.classes.prune();
        this.packages.prune();
    }

    public String unparse() {
        StringBuilder sb = new StringBuilder();
        sb.append("packages:\n");
        for (Map.Entry entry : this.packages.entrySet()) {
            sb.append("  " + (String)entry.getKey() + " => " + entry.getValue() + "\n");
        }
        sb.append("classes:\n");
        for (Map.Entry entry : this.classes.entrySet()) {
            sb.append("  " + (String)entry.getKey() + " => \n");
            sb.append(((AClass)entry.getValue()).unparse("    "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.unparse();
    }

    public static void checkClone(AScene s0, AScene s1) {
        AScene.checkCloneNotReferenceEqual(s0, s1);
        s0.prune();
        s1.prune();
        AScene.checkCloneMap(s0.packages, s1.packages);
        AScene.checkCloneMap(s0.classes, s1.classes);
    }

    private static void checkCloneNotReferenceEqual(Object o0, Object o1) {
        if (o0 == null || o1 == null) {
            throw new RuntimeException("clone check failed, null value: " + o0 + ", " + o1);
        }
        if (o0 == o1) {
            throw new RuntimeException("clone check failed, reference equality: " + o0 + " [" + o0.getClass() + "]");
        }
    }

    private static void checkStringsEqual(String s0, String s1) {
        if (s0 == s1) {
            return;
        }
        if (s0 == null || s1 == null || !s0.equals(s1)) {
            throw new RuntimeException("Nonequal strings: " + s0 + ", " + s1);
        }
    }

    private static void checkDescriptionsEqual(Object o0, Object o1) {
        if (o0 == o1) {
            return;
        }
        if (o0 == null || o1 == null) {
            throw new RuntimeException("Nonequal descriptions: " + o0 + ", " + o1);
        }
        if (!o0.equals(o1)) {
            throw new RuntimeException("Nonequal descriptions: " + o0 + ", " + o1);
        }
    }

    public static <K, V extends AElement> void checkCloneMap(VivifyingMap<K, V> m0, VivifyingMap<K, V> m1) {
        AScene.checkCloneNotReferenceEqual(m0, m1);
        LinkedHashSet keys = new LinkedHashSet();
        keys.addAll(m0.keySet());
        keys.addAll(m1.keySet());
        for (Object k : keys) {
            AScene.checkCloneAElement((AElement)m0.get(k), (AElement)m1.get(k));
        }
    }

    private static void checkCloneAElement(AElement e0, AElement e1) {
        AScene.checkCloneNotReferenceEqual(e0, e1);
        e0.accept(checkVisitor, e1);
    }

    private static <T> void checkCloneSet(Set<T> s0, Set<T> s1) {
        AScene.checkCloneNotReferenceEqual(s0, s1);
        if (!s0.equals(s1)) {
            throw new RuntimeException("clone check failed, different sets: " + s0 + ", " + s1);
        }
    }

    public static void main(String[] args) {
        int status = 0;
        checkClones = true;
        for (int i = 0; i < args.length; ++i) {
            AScene s0 = new AScene();
            System.out.print(args[i] + ": ");
            try {
                IndexFileParser.parseFile(args[i], s0);
                AScene ignore = s0.clone();
                System.out.println("ok");
                continue;
            }
            catch (Throwable e) {
                status = 1;
                System.out.println("failed");
                e.printStackTrace();
            }
        }
        System.exit(status);
    }
}

