/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.afu.annotator.Main;
import org.checkerframework.afu.annotator.find.ASTPathCriterion;
import org.checkerframework.afu.annotator.find.BoundLocationCriterion;
import org.checkerframework.afu.annotator.find.CallCriterion;
import org.checkerframework.afu.annotator.find.CastCriterion;
import org.checkerframework.afu.annotator.find.ClassBoundCriterion;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.find.EnclosedByCriterion;
import org.checkerframework.afu.annotator.find.ExtImplsLocationCriterion;
import org.checkerframework.afu.annotator.find.FieldCriterion;
import org.checkerframework.afu.annotator.find.GenericArrayLocationCriterion;
import org.checkerframework.afu.annotator.find.InClassCriterion;
import org.checkerframework.afu.annotator.find.InFieldInitCriterion;
import org.checkerframework.afu.annotator.find.InInitBlockCriterion;
import org.checkerframework.afu.annotator.find.InMethodCriterion;
import org.checkerframework.afu.annotator.find.InPackageCriterion;
import org.checkerframework.afu.annotator.find.InstanceOfCriterion;
import org.checkerframework.afu.annotator.find.IsCriterion;
import org.checkerframework.afu.annotator.find.IsSigMethodCriterion;
import org.checkerframework.afu.annotator.find.LambdaCriterion;
import org.checkerframework.afu.annotator.find.LocalVariableCriterion;
import org.checkerframework.afu.annotator.find.MemberReferenceCriterion;
import org.checkerframework.afu.annotator.find.MethodBoundCriterion;
import org.checkerframework.afu.annotator.find.NewCriterion;
import org.checkerframework.afu.annotator.find.NotInMethodCriterion;
import org.checkerframework.afu.annotator.find.PackageCriterion;
import org.checkerframework.afu.annotator.find.ParamCriterion;
import org.checkerframework.afu.annotator.find.ReceiverCriterion;
import org.checkerframework.afu.annotator.find.ReturnTypeCriterion;
import org.checkerframework.afu.annotator.find.TypeArgumentCriterion;
import org.checkerframework.afu.scenelib.el.BoundLocation;
import org.checkerframework.afu.scenelib.el.LocalLocation;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.afu.scenelib.el.TypeIndexLocation;
import org.checkerframework.afu.scenelib.io.ASTPath;
import org.checkerframework.afu.scenelib.io.DebugWriter;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.com.google.errorprone.annotations.InlineMe;
import org.checkerframework.org.objectweb.asm.TypePath;

public final class Criteria {
    public static DebugWriter dbug = new DebugWriter(false);
    private final Map<Criterion.Kind, Criterion> criteria = new LinkedHashMap<Criterion.Kind, Criterion>();

    public void add(Criterion c) {
        Criterion old = this.criteria.put(c.getKind(), c);
        if (old != null && !c.toString().equals(old.toString())) {
            throw new Error("Overwrote " + (Object)((Object)c.getKind()) + " => " + old + "; new = " + c);
        }
    }

    void addPermitReplacement(Criterion c) {
        this.criteria.put(c.getKind(), c);
    }

    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        for (Criterion c : this.criteria.values()) {
            if (!c.isSatisfiedBy(path, leaf)) {
                dbug.debug("UNsatisfied criterion of type %s [%s]:%n    leaf=%s%n", c, c.getClass(), Main.leafString(path));
                return false;
            }
            dbug.debug("satisfied criterion of type %s [%s]:%n    leaf=%s%n", c, c.getClass(), Main.leafString(path));
        }
        return !this.isSatisfiedByShouldReturnFalse(leaf);
    }

    public boolean isSatisfiedBy(@Nullable TreePath path) {
        for (Criterion c : this.criteria.values()) {
            if (!c.isSatisfiedBy(path)) {
                dbug.debug("UNsatisfied criterion: %s%n", c);
                return false;
            }
            dbug.debug("satisfied criterion: %s%n", c);
        }
        return !this.isSatisfiedByShouldReturnFalse(path.getLeaf());
    }

    private boolean isSatisfiedByShouldReturnFalse(Tree leaf) {
        return this.criteria.size() == 2 && this.isOnMethod("<init>()V") && this.criteria.containsKey((Object)Criterion.Kind.IN_CLASS) && !(leaf instanceof MethodTree);
    }

    public boolean isOnlyTypeAnnotationCriterion() {
        for (Criterion c : this.criteria.values()) {
            if (!c.isOnlyTypeAnnotationCriterion()) continue;
            return true;
        }
        return false;
    }

    public boolean isOnReceiver() {
        return this.criteria.containsKey((Object)Criterion.Kind.RECEIVER);
    }

    public boolean isOnPackage() {
        return this.criteria.containsKey((Object)Criterion.Kind.PACKAGE);
    }

    public boolean isOnReturnType() {
        return this.criteria.containsKey((Object)Criterion.Kind.RETURN_TYPE);
    }

    public boolean isOnLocalVariable() {
        return this.criteria.containsKey((Object)Criterion.Kind.LOCAL_VARIABLE);
    }

    public boolean isOnInstanceof() {
        return this.criteria.containsKey((Object)Criterion.Kind.INSTANCE_OF);
    }

    public boolean isOnNew() {
        return this.criteria.containsKey((Object)Criterion.Kind.NEW);
    }

    public boolean isOnTypeDeclarationExtendsClause() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.EXTIMPLS_LOCATION) continue;
            return ((ExtImplsLocationCriterion)c).getIndex() == -1;
        }
        return false;
    }

    public boolean isOnMethod(String methodname) {
        Criterion c = this.criteria.get((Object)Criterion.Kind.IN_METHOD);
        return c != null && ((InMethodCriterion)c).name.equals(methodname);
    }

    public boolean isOnFieldDeclaration() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.FIELD || !((FieldCriterion)c).isDeclaration) continue;
            return true;
        }
        return false;
    }

    public boolean isOnVariableDeclaration() {
        return this.isOnLocalVariable() || this.isOnFieldDeclaration();
    }

    public ASTPath getASTPath() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.AST_PATH) continue;
            return ((ASTPathCriterion)c).astPath;
        }
        return null;
    }

    public @Nullable @ClassGetName String getClassName() {
        String result = null;
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.IN_CLASS) continue;
            if (result == null) {
                result = ((InClassCriterion)c).className;
                continue;
            }
            throw new Error(String.format("In two classes: %s %s", result, ((InClassCriterion)c).className));
        }
        return result;
    }

    public String getMethodName() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.IN_METHOD) continue;
            return ((InMethodCriterion)c).name;
        }
        return null;
    }

    public String getFieldName() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.FIELD) continue;
            return ((FieldCriterion)c).varName;
        }
        return null;
    }

    public GenericArrayLocationCriterion getGenericArrayLocation() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.GENERIC_ARRAY_LOCATION) continue;
            return (GenericArrayLocationCriterion)c;
        }
        return null;
    }

    public RelativeLocation getCastRelativeLocation() {
        RelativeLocation result = null;
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.CAST) continue;
            result = ((CastCriterion)c).getLocation();
        }
        return result;
    }

    public InClassCriterion getInClass() {
        InClassCriterion result = null;
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.IN_CLASS) continue;
            result = (InClassCriterion)c;
        }
        return result;
    }

    public boolean onBoundZero() {
        block5: for (Criterion c : this.criteria.values()) {
            switch (c.getKind()) {
                case CLASS_BOUND: {
                    if (((ClassBoundCriterion)c).boundLoc.boundIndex != 0) break;
                    return true;
                }
                case METHOD_BOUND: {
                    if (((MethodBoundCriterion)c).boundLoc.boundIndex != 0) break;
                    return true;
                }
                case AST_PATH: {
                    ASTPath astPath = ((ASTPathCriterion)c).astPath;
                    if (astPath.isEmpty()) break;
                    ASTPath.ASTEntry entry = astPath.getLast();
                    if (!entry.childSelectorIs("bound") || entry.getArgument() != 0) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.criteria.toString();
    }

    public static final Criterion is(Tree.Kind kind, String name) {
        return new IsCriterion(kind, name);
    }

    public static final Criterion enclosedBy(Tree.Kind kind) {
        return new EnclosedByCriterion(kind);
    }

    public static final Criterion inPackage(String name) {
        return new InPackageCriterion(name);
    }

    public static final Criterion inClass(@ClassGetName String name, boolean exactMatch) {
        return new InClassCriterion(name, true);
    }

    public static final Criterion inMethod(String name) {
        return new InMethodCriterion(name);
    }

    public static final Criterion notInMethod() {
        return new NotInMethodCriterion();
    }

    public static final Criterion packageDecl(String packageName) {
        return new PackageCriterion(packageName);
    }

    public static final Criterion atLocation() {
        return new GenericArrayLocationCriterion();
    }

    public static final Criterion atLocation(TypePath loc) {
        return new GenericArrayLocationCriterion(loc);
    }

    @Deprecated
    @InlineMe(replacement="new FieldCriterion(varName)", imports={"org.checkerframework.afu.annotator.find.FieldCriterion"})
    public static final Criterion field(String varName) {
        return new FieldCriterion(varName);
    }

    public static final Criterion field(String varName, boolean isOnDeclaration) {
        return new FieldCriterion(varName, isOnDeclaration);
    }

    public static final Criterion inStaticInit(int blockID) {
        return new InInitBlockCriterion(blockID, true);
    }

    public static final Criterion inInstanceInit(int blockID) {
        return new InInitBlockCriterion(blockID, false);
    }

    public static final Criterion inFieldInit(String varName) {
        return new InFieldInitCriterion(varName);
    }

    public static final Criterion receiver(String methodName) {
        return new ReceiverCriterion(methodName);
    }

    public static final Criterion returnType(@ClassGetName String className, String methodName) {
        return new ReturnTypeCriterion(className, methodName);
    }

    public static final Criterion isSigMethod(String methodName) {
        return new IsSigMethodCriterion(methodName);
    }

    public static final Criterion param(String methodName, Integer pos) {
        return new ParamCriterion(methodName, pos);
    }

    public static final Criterion local(String methodName, LocalLocation loc) {
        return new LocalVariableCriterion(methodName, loc);
    }

    public static final Criterion cast(String methodName, RelativeLocation loc) {
        return new CastCriterion(methodName, loc);
    }

    public static final Criterion newObject(String methodName, RelativeLocation loc) {
        return new NewCriterion(methodName, loc);
    }

    public static final Criterion instanceOf(String methodName, RelativeLocation loc) {
        return new InstanceOfCriterion(methodName, loc);
    }

    public static Criterion memberReference(String methodName, RelativeLocation loc) {
        return new MemberReferenceCriterion(methodName, loc);
    }

    public static Criterion methodCall(String methodName, RelativeLocation loc) {
        return new CallCriterion(methodName, loc);
    }

    public static final Criterion typeArgument(String methodName, RelativeLocation loc) {
        return new TypeArgumentCriterion(methodName, loc);
    }

    public static final Criterion lambda(String methodName, RelativeLocation loc) {
        return new LambdaCriterion(methodName, loc);
    }

    public static final Criterion atBoundLocation(BoundLocation loc) {
        return new BoundLocationCriterion(loc);
    }

    public static final Criterion atExtImplsLocation(String className, TypeIndexLocation loc) {
        return new ExtImplsLocationCriterion(className, loc);
    }

    public static final Criterion methodBound(String methodName, BoundLocation boundLoc) {
        return new MethodBoundCriterion(methodName, boundLoc);
    }

    public static final Criterion classBound(String className, BoundLocation boundLoc) {
        return new ClassBoundCriterion(className, boundLoc);
    }

    public static final Criterion astPath(ASTPath astPath) {
        return new ASTPathCriterion(astPath);
    }
}

