/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.afu.annotator.Source;
import org.checkerframework.afu.annotator.find.AnnotationInsertion;
import org.checkerframework.afu.annotator.find.CastInsertion;
import org.checkerframework.afu.annotator.find.ConstructorInsertion;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.GenericArrayLocationCriterion;
import org.checkerframework.afu.annotator.find.Insertion;
import org.checkerframework.afu.annotator.find.Insertions;
import org.checkerframework.afu.annotator.find.NewInsertion;
import org.checkerframework.afu.annotator.find.ReceiverInsertion;
import org.checkerframework.afu.annotator.find.TreeFinder;
import org.checkerframework.afu.annotator.find.TypedInsertion;
import org.checkerframework.afu.annotator.scanner.LocalVariableScanner;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;
import org.checkerframework.afu.annotator.specification.IndexFileSpecification;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.ABlock;
import org.checkerframework.afu.scenelib.el.AClass;
import org.checkerframework.afu.scenelib.el.ADeclaration;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AExpression;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.ATypeElementWithType;
import org.checkerframework.afu.scenelib.el.AnnotationDef;
import org.checkerframework.afu.scenelib.el.DefException;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.el.LocalLocation;
import org.checkerframework.afu.scenelib.el.TypePathEntry;
import org.checkerframework.afu.scenelib.io.ASTIndex;
import org.checkerframework.afu.scenelib.io.ASTPath;
import org.checkerframework.afu.scenelib.io.ASTRecord;
import org.checkerframework.afu.scenelib.io.DebugWriter;
import org.checkerframework.afu.scenelib.io.IndexFileParser;
import org.checkerframework.afu.scenelib.io.IndexFileWriter;
import org.checkerframework.afu.scenelib.type.DeclaredType;
import org.checkerframework.afu.scenelib.type.Type;
import org.checkerframework.afu.scenelib.util.CommandLineUtils;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.com.google.common.collect.LinkedHashMultimap;
import org.checkerframework.com.google.common.collect.Multimap;
import org.checkerframework.com.google.common.collect.SetMultimap;
import org.checkerframework.org.plumelib.options.Option;
import org.checkerframework.org.plumelib.options.OptionGroup;
import org.checkerframework.org.plumelib.options.Options;
import org.checkerframework.org.plumelib.reflection.ReflectionPlume;
import org.checkerframework.org.plumelib.util.FileIOException;
import org.checkerframework.org.plumelib.util.FilesPlume;
import org.checkerframework.org.plumelib.util.IPair;

public class Main {
    @OptionGroup(value="General options")
    @Option(value="-d <directory> Directory in which output files are written")
    public static String outdir = "annotated/";
    @Option(value="-i Overwrite original source files")
    public static boolean in_place = false;
    @Option(value="-a Abbreviate annotation names")
    public static boolean abbreviate = true;
    @Option(value="-o Omit given annotation")
    public static String omit_annotation;
    @Option(value="Suppress warnings about disallowed insertions")
    public static boolean nowarn;
    @Option(value="Convert JAIFs to AST Path format, but do no insertion into source")
    public static boolean convert_jaifs;
    @Option(value="-h Print usage information and exit")
    public static boolean help;
    @OptionGroup(value="Debugging options")
    @Option(value="-v Verbose (print progress information)")
    public static boolean verbose;
    @Option(value="Debug (print debug information)")
    public static boolean debug;
    @Option(value="Print error stack")
    public static boolean print_error_stack;
    public static boolean temporaryDebug;
    private static ElementVisitor<Void, AElement> classFilter;
    private static Comparator<Insertion> insertionSorter;
    public static Map<String, Boolean> hasExplicitConstructor;
    private static Pattern javaLangClassPattern;

    private static AScene filteredScene(AScene scene) {
        AScene filtered = new AScene();
        filtered.packages.putAll(scene.packages);
        filtered.imports.putAll(scene.imports);
        for (Map.Entry entry : scene.classes.entrySet()) {
            String key = (String)entry.getKey();
            AClass clazz0 = (AClass)entry.getValue();
            AClass clazz1 = filtered.classes.getVivify(key);
            clazz0.accept(classFilter, clazz1);
        }
        filtered.prune();
        return filtered;
    }

    private static ATypeElement findInnerTypeElement(ASTRecord rec, ADeclaration decl, Insertion ins) {
        ASTPath astPath = rec.astPath;
        GenericArrayLocationCriterion galc = ins.getCriteria().getGenericArrayLocation();
        assert (astPath != null && galc != null);
        List<TypePathEntry> tpes = galc.getLocation();
        for (TypePathEntry tpe : tpes) {
            ASTPath.ASTEntry entry;
            switch (tpe.step) {
                case 0: {
                    if (!astPath.isEmpty() && (entry = astPath.getLast()).getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type")) {
                        entry = new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", entry.getArgument() + 1);
                        break;
                    }
                    entry = new ASTPath.ASTEntry(Tree.Kind.ARRAY_TYPE, "type");
                    break;
                }
                case 1: {
                    entry = new ASTPath.ASTEntry(Tree.Kind.MEMBER_SELECT, "expression");
                    break;
                }
                case 3: {
                    entry = new ASTPath.ASTEntry(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", tpe.argument);
                    break;
                }
                case 2: {
                    entry = new ASTPath.ASTEntry(Tree.Kind.UNBOUNDED_WILDCARD, "bound");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown type tag " + tpe.step);
                }
            }
            astPath = astPath.extend(entry);
        }
        return decl.insertAnnotations.getVivify(astPath);
    }

    private static void convertInsertion(String pkg, JCTree.JCCompilationUnit tree, ASTRecord rec, Insertion ins, AScene scene, Multimap<Insertion, Annotation> insertionSources) {
        block29: {
            Collection<Annotation> annos;
            block28: {
                annos = insertionSources.get(ins);
                if (rec != null) break block28;
                if (!ins.getCriteria().isOnPackage()) break block29;
                for (Annotation anno : annos) {
                    ((AElement)scene.packages.get((Object)pkg)).tlAnnotationsHere.add(anno);
                }
                break block29;
            }
            if (scene != null && rec.className != null) {
                int n;
                AClass clazz = scene.classes.getVivify(rec.className);
                ADeclaration decl = null;
                if (ins.getCriteria().onBoundZero() && !((ASTPath.ASTEntry)rec.astPath.get((n = rec.astPath.size()) - 1)).childSelectorIs("bound")) {
                    ASTPath astPath = ASTPath.empty();
                    for (int i = 0; i < n; ++i) {
                        astPath = astPath.extend((ASTPath.ASTEntry)rec.astPath.get(i));
                    }
                    astPath = astPath.extend(new ASTPath.ASTEntry(Tree.Kind.TYPE_PARAMETER, "bound", 0));
                    rec = rec.replacePath(astPath);
                }
                if (rec.methodName == null) {
                    decl = rec.varName == null ? clazz : (ADeclaration)clazz.fields.getVivify(rec.varName);
                } else {
                    AMethod meth = clazz.methods.getVivify(rec.methodName);
                    if (rec.varName == null) {
                        decl = meth;
                    } else {
                        try {
                            int i = Integer.parseInt(rec.varName);
                            decl = i < 0 ? meth.receiver : (ADeclaration)meth.parameters.getVivify(i);
                        }
                        catch (NumberFormatException e) {
                            Tree leaf;
                            TreePath path = ASTIndex.getTreePath(tree, rec);
                            JCTree.JCVariableDecl varTree = null;
                            JCTree.JCMethodDecl methTree = null;
                            block9: while (path != null) {
                                leaf = path.getLeaf();
                                switch (leaf.getKind()) {
                                    case VARIABLE: {
                                        varTree = (JCTree.JCVariableDecl)leaf;
                                        continue block9;
                                    }
                                    case METHOD: {
                                        methTree = (JCTree.JCMethodDecl)leaf;
                                        continue block9;
                                    }
                                    case ANNOTATION: 
                                    case CLASS: 
                                    case ENUM: 
                                    case INTERFACE: {
                                        break block9;
                                    }
                                    default: {
                                        path = path.getParentPath();
                                        continue block9;
                                    }
                                }
                            }
                            while (path != null) {
                                leaf = path.getLeaf();
                                Tree.Kind kind = leaf.getKind();
                                if (kind == Tree.Kind.METHOD) {
                                    methTree = (JCTree.JCMethodDecl)leaf;
                                    int i = LocalVariableScanner.indexOfVarTree(path, varTree, rec.varName);
                                    int m = methTree.getStartPosition();
                                    int a = varTree.getStartPosition();
                                    int b = varTree.getEndPosition(tree.endPositions);
                                    LocalLocation loc = new LocalLocation(i, a - m, b - a);
                                    decl = meth.body.locals.getVivify(loc);
                                    break;
                                }
                                if (ASTPath.isClassEquiv(kind)) break;
                                path = path.getParentPath();
                            }
                        }
                    }
                }
                if (decl != null) {
                    AElement el;
                    if (rec.astPath.isEmpty()) {
                        el = decl;
                    } else if (ins.getKind() == Insertion.Kind.CAST) {
                        ATypeElementWithType elem = decl.insertTypecasts.getVivify(rec.astPath);
                        elem.setType(((CastInsertion)ins).getType());
                        el = elem;
                    } else {
                        el = decl.insertAnnotations.getVivify(rec.astPath);
                    }
                    for (Annotation anno : annos) {
                        el.tlAnnotationsHere.add(anno);
                    }
                    if (ins instanceof TypedInsertion) {
                        TypedInsertion ti = (TypedInsertion)ins;
                        if (!rec.astPath.isEmpty()) {
                            // empty if block
                        }
                        for (Insertion inner : ti.getInnerTypeInsertions()) {
                            Tree t = ASTIndex.getNode(tree, rec);
                            if (t == null) continue;
                            ATypeElement elem = Main.findInnerTypeElement(rec, decl, inner);
                            for (Annotation a : insertionSources.get(inner)) {
                                elem.tlAnnotationsHere.add(a);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        boolean outdir_and_in_place;
        Object[] file_args;
        Object[] cl_args;
        if (verbose) {
            System.out.printf("insert-annotations-to-source (%s)%n", "Annotation File Utilities v3.9.14");
        }
        Options options = new Options("java org.checkerframework.afu.annotator.Main [options] { jaif-file | java-file | @arg-file } ..." + System.lineSeparator() + "(Contents of argfiles are expanded into the argument list.)", Main.class);
        try {
            cl_args = CommandLineUtils.parseCommandLine(args);
            file_args = options.parse(true, (String[])cl_args);
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.err.println("(For non-argfile beginning with \"@\", use \"@@\" for initial \"@\".");
            System.err.println("Alternative for filenames: indicate directory, e.g. as './@file'.");
            System.err.println("Alternative for flags: use '=', as in '-o=@Deprecated'.)");
            System.exit(1);
            throw new Error("Unreachable");
        }
        DebugWriter dbug = new DebugWriter(debug);
        DebugWriter verb = new DebugWriter(verbose);
        TreeFinder.warn.setEnabled(!nowarn);
        TreeFinder.dbug.setEnabled(debug);
        Criteria.dbug.setEnabled(debug);
        if (help) {
            options.printUsage();
            System.exit(0);
        }
        boolean bl = outdir_and_in_place = in_place && outdir != "annotated/";
        if (outdir_and_in_place) {
            System.out.println("The --outdir and --in-place options are mutually exclusive.");
            options.printUsage();
            System.exit(1);
        }
        if (file_args.length < 2) {
            System.out.printf("Supplied %d arguments, at least 2 needed%n", file_args.length);
            System.out.printf("Supplied arguments: %s%n", Arrays.toString(args));
            System.out.printf("  (After javac parsing, remaining arguments = %s)%n", Arrays.toString(cl_args));
            System.out.printf("  (File arguments = %s)%n", Arrays.toString(file_args));
            options.printUsage();
            System.exit(1);
        }
        ArrayList<String> jaifFiles = new ArrayList<String>();
        ArrayList<String> javafiles = new ArrayList<String>();
        for (String string : file_args) {
            if (string.endsWith(".java")) {
                javafiles.add(string);
                continue;
            }
            if (string.endsWith(".jaif") || string.endsWith(".jann")) {
                jaifFiles.add(string);
                continue;
            }
            System.out.println("Unrecognized file extension: " + string);
            System.exit(1);
            throw new Error("unreachable");
        }
        Main.computeConstructors(javafiles);
        Insertions insertions = new Insertions();
        HashMap insertionIndex = new HashMap();
        HashMap<Insertion, String> insertionOrigins = new HashMap<Insertion, String>();
        HashMap<String, AScene> hashMap = new HashMap<String, AScene>();
        HashMap<String, Set<String>> annotationImports = new HashMap<String, Set<String>>();
        IndexFileParser.setAbbreviate(abbreviate);
        for (String jaifFile : jaifFiles) {
            IndexFileSpecification spec = new IndexFileSpecification(jaifFile);
            try {
                List<Insertion> parsedSpec = spec.parse();
                if (temporaryDebug) {
                    System.out.printf("parsedSpec (size %d):%n", parsedSpec.size());
                    for (Insertion insertion : parsedSpec) {
                        System.out.printf("  %s, isInserted=%s%n", insertion, insertion.isInserted());
                    }
                }
                AScene scene = spec.getScene();
                Collections.sort(parsedSpec, new Comparator<Insertion>(){

                    @Override
                    public int compare(Insertion i1, Insertion i2) {
                        ASTPath p1 = i1.getCriteria().getASTPath();
                        ASTPath p2 = i2.getCriteria().getASTPath();
                        return p1 == null ? (p2 == null ? 0 : -1) : (p2 == null ? 1 : p1.compareTo(p2));
                    }
                });
                if (convert_jaifs) {
                    hashMap.put(jaifFile, Main.filteredScene(scene));
                    for (Object ins : parsedSpec) {
                        insertionOrigins.put((Insertion)ins, jaifFile);
                    }
                    if (!insertionIndex.containsKey(jaifFile)) {
                        insertionIndex.put(jaifFile, LinkedHashMultimap.create());
                    }
                    ((Multimap)insertionIndex.get(jaifFile)).putAll(spec.insertionSources());
                }
                verb.debug("Read %d annotations from %s%n", parsedSpec.size(), jaifFile);
                if (omit_annotation != null) {
                    Object ins;
                    ArrayList<Insertion> arrayList = new ArrayList<Insertion>(parsedSpec.size());
                    ins = parsedSpec.iterator();
                    while (ins.hasNext()) {
                        Insertion insertion = (Insertion)ins.next();
                        if (omit_annotation.equals(insertion.getText())) continue;
                        arrayList.add(insertion);
                    }
                    parsedSpec = arrayList;
                    verb.debug("After filtering: %d annotations from %s%n", parsedSpec.size(), jaifFile);
                }
                insertions.addAll(parsedSpec);
                annotationImports.putAll(spec.annotationImports());
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) {
                    System.err.println("File not found: " + jaifFile);
                    System.exit(1);
                    continue;
                }
                throw e;
            }
            catch (FileIOException e) {
                System.err.println("Error while parsing annotation file " + jaifFile + " at line " + (e.lineNumber + 1) + ":");
                if (e.getMessage() != null) {
                    System.err.println("  " + e.getMessage());
                }
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    String causeMessage = e.getCause().getMessage();
                    System.err.println("  " + causeMessage);
                    if (causeMessage.startsWith("Could not load class: ")) {
                        System.err.println("To fix the problem, add class " + causeMessage.substring(22) + " to the classpath.");
                        System.err.println("The classpath is:");
                        System.err.println(ReflectionPlume.classpathToString());
                    }
                }
                if (print_error_stack) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
        }
        if (dbug.isEnabled()) {
            dbug.debug("In org.checkerframework.afu.annotator.Main:%n", new Object[0]);
            dbug.debug("%d insertions, %d .java files%n", insertions.size(), javafiles.size());
            dbug.debug("Insertions:%n", new Object[0]);
            for (Insertion insertion : insertions) {
                dbug.debug("  %s, isInserted=%s%n", insertion, insertion.isInserted());
            }
        }
        for (String javafilename : javafiles) {
            String string;
            Source src;
            verb.debug("Processing %s%n", javafilename);
            File javafile = new File(javafilename);
            File unannotated = new File(javafilename + ".unannotated");
            if (in_place && unannotated.exists()) {
                verb.debug("Renaming %s to %s%n", unannotated, javafile);
                boolean success = unannotated.renameTo(javafile);
                if (!success) {
                    throw new Error(String.format("Failed renaming %s to %s", unannotated, javafile));
                }
            }
            if ((src = Main.fileToSource(javafilename)) == null) {
                return;
            }
            verb.debug("Parsed %s%n", javafilename);
            try {
                string = FilesPlume.inferLineSeparator(javafilename);
            }
            catch (IOException e) {
                throw new Error("Cannot read " + javafilename, e);
            }
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            int num_insertions = 0;
            String pkg = "";
            for (CompilationUnitTree compilationUnitTree : src.parse()) {
                JCTree.JCCompilationUnit tree = (JCTree.JCCompilationUnit)compilationUnitTree;
                ExpressionTree pkgExp = compilationUnitTree.getPackageName();
                pkg = pkgExp == null ? "" : pkgExp.toString();
                TreeFinder finder = new TreeFinder(tree);
                SetMultimap<IPair<Integer, ASTPath>, Insertion> positions = finder.getPositions(tree, insertions);
                if (dbug.isEnabled()) {
                    dbug.debug("In org.checkerframework.afu.annotator.Main:%n", new Object[0]);
                    dbug.debug("positions (for %d insertions) = %s%n", insertions.size(), positions);
                }
                if (convert_jaifs) {
                    SetMultimap<ASTRecord, Insertion> astInsertions = finder.getPaths();
                    for (Map.Entry entry : astInsertions.asMap().entrySet()) {
                        ASTRecord rec = (ASTRecord)entry.getKey();
                        for (Insertion ins : entry.getValue()) {
                            if (ins.getCriteria().getASTPath() != null) continue;
                            String arg = (String)insertionOrigins.get(ins);
                            AScene scene = (AScene)hashMap.get(arg);
                            Multimap insertionSources = (Multimap)insertionIndex.get(arg);
                            if (!insertionSources.containsKey(ins)) continue;
                            Main.convertInsertion(pkg, tree, rec, ins, scene, insertionSources);
                        }
                    }
                    continue;
                }
                verb.debug("getPositions returned %d positions in tree for %s%n", positions.size(), javafilename);
                Set positionKeysUnsorted = positions.keySet();
                TreeSet<IPair<Integer, ASTPath>> positionKeysSorted = new TreeSet<IPair<Integer, ASTPath>>(new Comparator<IPair<Integer, ASTPath>>(){

                    @Override
                    public int compare(IPair<Integer, ASTPath> p1, IPair<Integer, ASTPath> p2) {
                        int c = Integer.compare((Integer)p2.first, (Integer)p1.first);
                        if (c != 0) {
                            return c;
                        }
                        return p2.second == null ? (p1.second == null ? 0 : -1) : (p1.second == null ? 1 : ((ASTPath)p2.second).compareTo((ASTPath)p1.second));
                    }
                });
                positionKeysSorted.addAll(positionKeysUnsorted);
                for (IPair pair : positionKeysSorted) {
                    boolean receiverInserted = false;
                    boolean newInserted = false;
                    boolean constructorInserted = false;
                    TreeSet<String> seen = new TreeSet<String>();
                    ArrayList<Insertion> toInsertList = new ArrayList<Insertion>(positions.get((Object)pair));
                    toInsertList.sort(insertionSorter);
                    dbug.debug("insertion pos: %d%n", pair.first);
                    dbug.debug("insertions sorted: %s%n", toInsertList);
                    assert ((Integer)pair.first >= 0) : "pos is negative: " + pair.first + " " + toInsertList.get(0) + " " + javafilename;
                    for (Insertion iToInsert : toInsertList) {
                        AnnotationInsertion annoToInsert;
                        Set annoImports;
                        String trailingWhitespace = "";
                        boolean gotSeparateLine = false;
                        int pos = (Integer)pair.first;
                        if (iToInsert.isSeparateLine()) {
                            int indentation = 0;
                            while (pos - indentation != 0 && (src.charAt(pos - indentation - 1) == ' ' || src.charAt(pos - indentation - 1) == '\t')) {
                                ++indentation;
                            }
                            if (pos - indentation == 0 || src.charAt(pos - indentation - 1) == '\f' || src.charAt(pos - indentation - 1) == '\n' || src.charAt(pos - indentation - 1) == '\r') {
                                trailingWhitespace = string + src.substring(pos - indentation, pos);
                                gotSeparateLine = true;
                            }
                        }
                        int precedingChar = pos != 0 ? src.charAt(pos - 1) : 0;
                        if (iToInsert.getKind() == Insertion.Kind.ANNOTATION) {
                            AnnotationInsertion ai = (AnnotationInsertion)iToInsert;
                            if (ai.isGenerateBound()) {
                                try {
                                    String s2 = src.substring(pos, pos + 9);
                                    if ("Object & ".equals(s2)) {
                                        ai.setGenerateBound(false);
                                        precedingChar = 46;
                                    }
                                }
                                catch (StringIndexOutOfBoundsException s2) {
                                    // empty catch block
                                }
                            }
                            if (ai.isGenerateExtends()) {
                                try {
                                    String s3 = src.substring(pos, pos + 9);
                                    if (" extends ".equals(s3)) {
                                        ai.setGenerateExtends(false);
                                        pos += 8;
                                    }
                                }
                                catch (StringIndexOutOfBoundsException s3) {}
                            }
                        } else if (iToInsert.getKind() == Insertion.Kind.CAST) {
                            ((CastInsertion)iToInsert).setOnArrayLiteral(src.charAt(pos) == '{');
                        } else if (iToInsert.getKind() == Insertion.Kind.RECEIVER) {
                            ReceiverInsertion ri = (ReceiverInsertion)iToInsert;
                            ri.setAnnotationsOnly(receiverInserted);
                            receiverInserted = true;
                        } else if (iToInsert.getKind() == Insertion.Kind.NEW) {
                            NewInsertion ni = (NewInsertion)iToInsert;
                            ni.setAnnotationsOnly(newInserted);
                            newInserted = true;
                        } else if (iToInsert.getKind() == Insertion.Kind.CONSTRUCTOR) {
                            ConstructorInsertion ci = (ConstructorInsertion)iToInsert;
                            if (constructorInserted) {
                                ci.setAnnotationsOnly(true);
                            }
                            constructorInserted = true;
                        }
                        String toInsert = iToInsert.getText(abbreviate, gotSeparateLine, pos, (char)precedingChar) + trailingWhitespace;
                        if (seen.contains(toInsert)) continue;
                        seen.add(toInsert);
                        if (toInsert.startsWith("@")) {
                            String precedingTextPlusChar;
                            int precedingTextPos = pos - toInsert.length() - 1;
                            if (precedingTextPos >= 0 && (toInsert.equals((precedingTextPlusChar = src.getString().substring(precedingTextPos, pos)).substring(0, toInsert.length())) || toInsert.equals(precedingTextPlusChar.substring(1)))) {
                                dbug.debug("Inserting '%s' at %d in code of length %d with preceding text '%s'%n", toInsert, pos, src.getString().length(), precedingTextPlusChar);
                                dbug.debug("Already present, skipping%n", new Object[0]);
                                continue;
                            }
                            int followingTextEndPos = pos + toInsert.length();
                            if (followingTextEndPos < src.getString().length()) {
                                String followingText = src.getString().substring(pos, followingTextEndPos);
                                dbug.debug("followingText=\"%s\"%n", followingText);
                                dbug.debug("toInsert=\"%s\"%n", toInsert);
                                String toInsertNoWs = toInsert.substring(0, toInsert.length() - 1);
                                if (followingText.equals(toInsert) || followingText.substring(0, followingText.length() - 1).equals(toInsertNoWs) && Character.isWhitespace(src.getString().charAt(followingTextEndPos))) {
                                    dbug.debug("Already present, skipping %s%n", toInsertNoWs);
                                    continue;
                                }
                            }
                        }
                        if (iToInsert.isInserted()) continue;
                        src.insert(pos, toInsert);
                        if (verbose && !debug) {
                            System.out.print(".");
                            if (++num_insertions % 50 == 0) {
                                System.out.println();
                            }
                        }
                        dbug.debug("Post-insertion source: %s%n", src.getString());
                        Collection<String> packageNames = Main.nonJavaLangClasses(iToInsert.getPackageNames());
                        if (!packageNames.isEmpty()) {
                            dbug.debug("Need import %s%n  due to insertion %s%n", packageNames, toInsert);
                            imports.addAll(packageNames);
                        }
                        if (!(iToInsert instanceof AnnotationInsertion) || (annoImports = (Set)annotationImports.get((annoToInsert = (AnnotationInsertion)iToInsert).getAnnotationFullyQualifiedName())) == null) continue;
                        imports.addAll(annoImports);
                    }
                }
            }
            if (convert_jaifs) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    String filename = (String)entry.getKey();
                    AScene scene = (AScene)entry.getValue();
                    try {
                        IndexFileWriter.write(scene, filename + ".converted");
                    }
                    catch (DefException e) {
                        System.err.println(filename + ":  format error in conversion");
                        if (!print_error_stack) continue;
                        e.printStackTrace();
                    }
                }
                return;
            }
            if (dbug.isEnabled()) {
                dbug.debug("%d imports to insert%n", imports.size());
                for (String string2 : imports) {
                    dbug.debug("  %s%n", string2);
                }
            }
            Pattern importPattern = Pattern.compile("(?m)^import\\b");
            Pattern pattern = Pattern.compile("(?m)^package\\b.*;(\\n|\\r\\n?)");
            int importIndex = 0;
            String srcString = src.getString();
            Matcher m = importPattern.matcher(srcString);
            TreeSet<String> inSource = new TreeSet<String>();
            if (m.find()) {
                importIndex = m.start();
                do {
                    int i = m.start();
                    int j = srcString.indexOf(System.lineSeparator(), i) + 1;
                    if (j <= 0) {
                        j = srcString.length();
                    }
                    String string3 = srcString.substring(i, j);
                    inSource.add(string3);
                } while (m.find());
            } else {
                m = pattern.matcher(srcString);
                if (m.find()) {
                    importIndex = m.end();
                }
            }
            for (String classname : imports) {
                String string4 = "import " + classname + ";" + string;
                if (inSource.contains(string4)) continue;
                inSource.add(string4);
                src.insert(importIndex, string4);
                importIndex += string4.length();
            }
            File outfile = null;
            try {
                if (in_place) {
                    boolean bl2;
                    outfile = javafile;
                    if (verbose) {
                        System.out.printf("Renaming %s to %s%n", javafile, unannotated);
                    }
                    if (!(bl2 = javafile.renameTo(unannotated))) {
                        throw new Error(String.format("Failed renaming %s to %s", javafile, unannotated));
                    }
                } else {
                    if (pkg.isEmpty()) {
                        outfile = new File(outdir, javafile.getName());
                    } else {
                        String[] stringArray = pkg.split("\\.");
                        StringBuilder sb = new StringBuilder(outdir);
                        for (int i = 0; i < stringArray.length; ++i) {
                            sb.append(File.separator).append(stringArray[i]);
                        }
                        outfile = new File(sb.toString(), javafile.getName());
                    }
                    outfile.getParentFile().mkdirs();
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(outfile);){
                    if (verbose) {
                        System.out.printf("Writing %s%n", outfile);
                    }
                    src.write(fileOutputStream);
                }
            }
            catch (IOException iOException) {
                System.err.println("Problem while writing file " + outfile);
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static Source fileToSource(String javaFileName) {
        try {
            Source src = new Source(javaFileName);
            return src;
        }
        catch (Source.CompilerException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void computeConstructors(List<String> javaFiles) {
        for (String javaFile : javaFiles) {
            Source src = Main.fileToSource(javaFile);
            if (src == null) continue;
            for (CompilationUnitTree cut : src.parse()) {
                TreePathScanner<Void, Void> constructorsScanner = new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitClass(ClassTree ct, Void p) {
                        String className = TreePathUtil.getBinaryName(this.getCurrentPath());
                        hasExplicitConstructor.put(className, TreePathUtil.hasConstructor(ct));
                        return (Void)super.visitClass(ct, null);
                    }
                };
                constructorsScanner.scan(cut, null);
            }
        }
    }

    private static boolean isJavaLangClass(String classname) {
        Matcher m = javaLangClassPattern.matcher(classname);
        return m.matches();
    }

    private static Collection<String> nonJavaLangClasses(Collection<String> classnames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String classname : classnames) {
            if (Main.isJavaLangClass(classname)) continue;
            result.add(classname);
        }
        return result;
    }

    public static String leafString(TreePath path) {
        if (path == null) {
            return "null path";
        }
        return Main.treeToString(path.getLeaf());
    }

    public static String treeToString(Tree node) {
        String asString = node.toString();
        String oneLine = Main.first80(asString);
        if (oneLine.endsWith(" ")) {
            oneLine = oneLine.substring(0, oneLine.length() - 1);
        }
        return oneLine;
    }

    public static String firstLine(String s) {
        while (s.startsWith("\n")) {
            s = s.substring(1);
        }
        int newlineIndex = s.indexOf(10);
        if (newlineIndex == -1) {
            return s;
        }
        return s.substring(0, newlineIndex) + "...";
    }

    public static String first80(String s) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        while (i < s.length() && sb.length() < 80) {
            if (s.charAt(i) == '\n') {
                ++i;
                while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
                    ++i;
                }
                sb.append(' ');
            }
            if (i < s.length()) {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        if (i < s.length()) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static IPair<String, @Nullable String> removeArgs(String s) {
        int pidx = s.indexOf(40);
        return pidx == -1 ? IPair.of(s, null) : IPair.of(s.substring(0, pidx), s.substring(pidx));
    }

    static {
        convert_jaifs = false;
        help = false;
        verbose = false;
        debug = false;
        print_error_stack = false;
        temporaryDebug = false;
        classFilter = new ElementVisitor<Void, AElement>(){

            <K, V extends AElement> Void filter(VivifyingMap<K, V> vm0, VivifyingMap<K, V> vm1) {
                for (Map.Entry entry : vm0.entrySet()) {
                    ((AElement)entry.getValue()).accept(this, (AElement)vm1.getVivify(entry.getKey()));
                }
                return null;
            }

            @Override
            public Void visitAnnotationDef(AnnotationDef def, AElement el) {
                return null;
            }

            @Override
            public Void visitBlock(ABlock el0, AElement el) {
                ABlock el1 = (ABlock)el;
                this.filter(el0.locals, el1.locals);
                return this.visitExpression((AExpression)el0, el);
            }

            @Override
            public Void visitClass(AClass el0, AElement el) {
                AClass el1 = (AClass)el;
                this.filter(el0.methods, el1.methods);
                this.filter(el0.fields, el1.fields);
                this.filter(el0.fieldInits, el1.fieldInits);
                this.filter(el0.staticInits, el1.staticInits);
                this.filter(el0.instanceInits, el1.instanceInits);
                return this.visitDeclaration((ADeclaration)el0, el);
            }

            @Override
            public Void visitDeclaration(ADeclaration el0, AElement el) {
                ATypeElement e;
                ASTPath p;
                ADeclaration el1 = (ADeclaration)el;
                VivifyingMap<ASTPath, ATypeElement> insertAnnotations = el1.insertAnnotations;
                VivifyingMap<ASTPath, ATypeElementWithType> insertTypecasts = el1.insertTypecasts;
                for (Map.Entry entry : el0.insertAnnotations.entrySet()) {
                    p = (ASTPath)entry.getKey();
                    e = (ATypeElement)entry.getValue();
                    insertAnnotations.put(p, e);
                }
                for (Map.Entry entry : el0.insertTypecasts.entrySet()) {
                    p = (ASTPath)entry.getKey();
                    e = (ATypeElementWithType)entry.getValue();
                    Type type = ((ATypeElementWithType)e).getType();
                    if (type instanceof DeclaredType && ((DeclaredType)type).getName().isEmpty()) {
                        insertAnnotations.put(p, e);
                        continue;
                    }
                    insertTypecasts.put(p, (ATypeElementWithType)e);
                }
                return null;
            }

            @Override
            public Void visitExpression(AExpression el0, AElement el) {
                AExpression el1 = (AExpression)el;
                this.filter(el0.typecasts, el1.typecasts);
                this.filter(el0.instanceofs, el1.instanceofs);
                this.filter(el0.news, el1.news);
                return null;
            }

            @Override
            public Void visitField(AField el0, AElement el) {
                return this.visitDeclaration((ADeclaration)el0, el);
            }

            @Override
            public Void visitMethod(AMethod el0, AElement el) {
                AMethod el1 = (AMethod)el;
                this.filter(el0.bounds, el1.bounds);
                el0.returnType.accept(this, el1.returnType);
                el0.receiver.accept(this, el1.receiver);
                this.filter(el0.parameters, el1.parameters);
                this.filter(el0.throwsException, el1.throwsException);
                this.filter(el0.preconditions, el1.preconditions);
                this.filter(el0.postconditions, el1.postconditions);
                el0.body.accept(this, el1.body);
                return this.visitDeclaration((ADeclaration)el0, el);
            }

            @Override
            public Void visitTypeElement(ATypeElement el0, AElement el) {
                ATypeElement el1 = (ATypeElement)el;
                this.filter(el0.innerTypes, el1.innerTypes);
                return null;
            }

            @Override
            public Void visitTypeElementWithType(ATypeElementWithType el0, AElement el) {
                ATypeElementWithType el1 = (ATypeElementWithType)el;
                el1.setType(el0.getType());
                return this.visitTypeElement((ATypeElement)el0, el);
            }

            @Override
            public Void visitElement(AElement el, AElement arg) {
                return null;
            }
        };
        insertionSorter = new Comparator<Insertion>(){

            @Override
            public int compare(Insertion i1, Insertion i2) {
                boolean separateLine1 = i1.isSeparateLine();
                boolean separateLine2 = i2.isSeparateLine();
                if (separateLine1 && !separateLine2) {
                    return 1;
                }
                if (separateLine2 && !separateLine1) {
                    return -1;
                }
                return -i1.getText().compareTo(i2.getText());
            }
        };
        hasExplicitConstructor = new HashMap<String, Boolean>();
        javaLangClassPattern = Pattern.compile("^java\\.lang\\.[A-Za-z0-9_]+$");
    }
}

