/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

final class EnclosedByCriterion
implements Criterion {
    private final Tree.Kind kind;

    EnclosedByCriterion(Tree.Kind kind) {
        this.kind = kind;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.ENCLOSED_BY;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        for (Tree tree : path) {
            if (tree.getKind() != this.kind) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    public String toString() {
        return "enclosed by '" + (Object)((Object)this.kind) + "'";
    }
}

