/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public abstract class AbstractLog {
    protected JCDiagnostic.Factory diags;
    protected DiagnosticSource source;
    protected Map<JavaFileObject, DiagnosticSource> sourceMap;

    AbstractLog(JCDiagnostic.Factory factory) {
        this.diags = factory;
        this.sourceMap = new HashMap<JavaFileObject, DiagnosticSource>();
    }

    public JavaFileObject useSource(JavaFileObject javaFileObject) {
        JavaFileObject javaFileObject2 = this.source == null ? null : this.source.getFile();
        this.source = this.getSource(javaFileObject);
        return javaFileObject2;
    }

    protected DiagnosticSource getSource(JavaFileObject javaFileObject) {
        if (javaFileObject == null) {
            return DiagnosticSource.NO_SOURCE;
        }
        DiagnosticSource diagnosticSource = this.sourceMap.get(javaFileObject);
        if (diagnosticSource == null) {
            diagnosticSource = new DiagnosticSource(javaFileObject, this);
            this.sourceMap.put(javaFileObject, diagnosticSource);
        }
        return diagnosticSource;
    }

    public DiagnosticSource currentSource() {
        return this.source;
    }

    public void error(String string, Object ... objectArray) {
        this.error(this.diags.errorKey(string, objectArray));
    }

    public void error(JCDiagnostic.Error error) {
        this.report(this.diags.error(null, this.source, null, error));
    }

    public void error(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.error(diagnosticPosition, this.diags.errorKey(string, objectArray));
    }

    public void error(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Error error) {
        this.report(this.diags.error(null, this.source, diagnosticPosition, error));
    }

    public void error(JCDiagnostic.DiagnosticFlag diagnosticFlag, JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.error(diagnosticFlag, diagnosticPosition, this.diags.errorKey(string, objectArray));
    }

    public void error(JCDiagnostic.DiagnosticFlag diagnosticFlag, JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Error error) {
        this.report(this.diags.error(diagnosticFlag, this.source, diagnosticPosition, error));
    }

    public void error(int n, String string, Object ... objectArray) {
        this.error(n, this.diags.errorKey(string, objectArray));
    }

    public void error(int n, JCDiagnostic.Error error) {
        this.report(this.diags.error(null, this.source, this.wrap(n), error));
    }

    public void error(JCDiagnostic.DiagnosticFlag diagnosticFlag, int n, String string, Object ... objectArray) {
        this.error(diagnosticFlag, n, this.diags.errorKey(string, objectArray));
    }

    public void error(JCDiagnostic.DiagnosticFlag diagnosticFlag, int n, JCDiagnostic.Error error) {
        this.report(this.diags.error(diagnosticFlag, this.source, this.wrap(n), error));
    }

    public void warning(String string, Object ... objectArray) {
        this.warning(this.diags.warningKey(string, objectArray));
    }

    public void warning(JCDiagnostic.Warning warning) {
        this.report(this.diags.warning(null, this.source, null, warning));
    }

    public void warning(Lint.LintCategory lintCategory, String string, Object ... objectArray) {
        this.warning(lintCategory, this.diags.warningKey(string, objectArray));
    }

    public void warning(Lint.LintCategory lintCategory, JCDiagnostic.Warning warning) {
        this.report(this.diags.warning(lintCategory, null, null, warning));
    }

    public void warning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.warning(diagnosticPosition, this.diags.warningKey(string, objectArray));
    }

    public void warning(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Warning warning) {
        this.report(this.diags.warning(null, this.source, diagnosticPosition, warning));
    }

    public void warning(Lint.LintCategory lintCategory, JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.warning(lintCategory, diagnosticPosition, this.diags.warningKey(string, objectArray));
    }

    public void warning(Lint.LintCategory lintCategory, JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Warning warning) {
        this.report(this.diags.warning(lintCategory, this.source, diagnosticPosition, warning));
    }

    public void warning(int n, String string, Object ... objectArray) {
        this.warning(n, this.diags.warningKey(string, objectArray));
    }

    public void warning(int n, JCDiagnostic.Warning warning) {
        this.report(this.diags.warning(null, this.source, this.wrap(n), warning));
    }

    public void mandatoryWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.mandatoryWarning(diagnosticPosition, this.diags.warningKey(string, objectArray));
    }

    public void mandatoryWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Warning warning) {
        this.report(this.diags.mandatoryWarning(null, this.source, diagnosticPosition, warning));
    }

    public void mandatoryWarning(Lint.LintCategory lintCategory, JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.mandatoryWarning(lintCategory, diagnosticPosition, this.diags.warningKey(string, objectArray));
    }

    public void mandatoryWarning(Lint.LintCategory lintCategory, JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Warning warning) {
        this.report(this.diags.mandatoryWarning(lintCategory, this.source, diagnosticPosition, warning));
    }

    public void note(String string, Object ... objectArray) {
        this.note(this.diags.noteKey(string, objectArray));
    }

    public void note(JCDiagnostic.Note note) {
        this.report(this.diags.note(this.source, null, note));
    }

    public void note(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.note(diagnosticPosition, this.diags.noteKey(string, objectArray));
    }

    public void note(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Note note) {
        this.report(this.diags.note(this.source, diagnosticPosition, note));
    }

    public void note(int n, String string, Object ... objectArray) {
        this.note(n, this.diags.noteKey(string, objectArray));
    }

    public void note(int n, JCDiagnostic.Note note) {
        this.report(this.diags.note(this.source, this.wrap(n), note));
    }

    public void note(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        this.note(javaFileObject, this.diags.noteKey(string, objectArray));
    }

    public void note(JavaFileObject javaFileObject, JCDiagnostic.Note note) {
        this.report(this.diags.note(this.getSource(javaFileObject), null, note));
    }

    public void mandatoryNote(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        this.mandatoryNote(javaFileObject, this.diags.noteKey(string, objectArray));
    }

    public void mandatoryNote(JavaFileObject javaFileObject, JCDiagnostic.Note note) {
        this.report(this.diags.mandatoryNote(this.getSource(javaFileObject), note));
    }

    protected abstract void report(JCDiagnostic var1);

    protected abstract void directError(String var1, Object ... var2);

    private JCDiagnostic.DiagnosticPosition wrap(int n) {
        return n == -1 ? null : new JCDiagnostic.SimpleDiagnosticPosition(n);
    }
}

