/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.RelativePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

public abstract class PathFileObject
implements JavaFileObject {
    private static final FileSystem defaultFileSystem = FileSystems.getDefault();
    private static final boolean isMacOS = System.getProperty("os.name", "").contains("OS X");
    protected final BaseFileManager fileManager;
    protected final Path path;
    private boolean hasParents;

    static PathFileObject forDirectoryPath(BaseFileManager baseFileManager, Path path, Path path2, RelativePath relativePath) {
        return new DirectoryFileObject(baseFileManager, path, path2, relativePath);
    }

    public static PathFileObject forJarPath(BaseFileManager baseFileManager, Path path, Path path2) {
        return new JarFileObject(baseFileManager, path, path2);
    }

    public static PathFileObject forJRTPath(BaseFileManager baseFileManager, Path path) {
        return new JRTFileObject(baseFileManager, path);
    }

    static PathFileObject forSimplePath(BaseFileManager baseFileManager, Path path, Path path2) {
        return new SimpleFileObject(baseFileManager, path, path2);
    }

    protected PathFileObject(BaseFileManager baseFileManager, Path path) {
        this.fileManager = Objects.requireNonNull(baseFileManager);
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("directories not supported");
        }
        this.path = path;
    }

    abstract String inferBinaryName(Iterable<? extends Path> var1);

    abstract PathFileObject getSibling(String var1);

    public Path getPath() {
        return this.path;
    }

    public String getShortName() {
        return this.path.getFileName().toString();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return BaseFileManager.getKind(this.path);
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        return this.isPathNameCompatible(this.path, string, kind);
    }

    protected boolean isPathNameCompatible(Path path, String string, JavaFileObject.Kind kind) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(kind);
        if (kind == JavaFileObject.Kind.OTHER && BaseFileManager.getKind(path) != kind) {
            return false;
        }
        String string2 = string + kind.extension;
        String string3 = path.getFileName().toString();
        if (string3.equals(string2)) {
            return true;
        }
        if (path.getFileSystem() == defaultFileSystem) {
            String string4;
            if (isMacOS && Normalizer.isNormalized(string3, Normalizer.Form.NFD) && Normalizer.isNormalized(string2, Normalizer.Form.NFC) && (string4 = Normalizer.normalize(string3, Normalizer.Form.NFC)).equals(string2)) {
                return true;
            }
            if (string3.equalsIgnoreCase(string2)) {
                try {
                    return path.toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString().equals(string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        this.fileManager.updateLastUsedTime();
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.fileManager.updateLastUsedTime();
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        CharsetDecoder charsetDecoder = this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
        return new InputStreamReader(this.openInputStream(), charsetDecoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getCharContent(boolean bl) throws IOException {
        CharBuffer charBuffer = this.fileManager.getCachedContent(this);
        if (charBuffer == null) {
            try (InputStream inputStream = this.openInputStream();){
                ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(inputStream);
                JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                try {
                    charBuffer = this.fileManager.decode(byteBuffer, bl);
                }
                finally {
                    this.fileManager.log.useSource(javaFileObject);
                }
                this.fileManager.recycleByteBuffer(byteBuffer);
                if (!bl) {
                    this.fileManager.cache(this, charBuffer);
                }
            }
        }
        return charBuffer;
    }

    @Override
    public Writer openWriter() throws IOException {
        this.fileManager.updateLastUsedTime();
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter(Files.newOutputStream(this.path, new OpenOption[0]), this.fileManager.getEncodingName());
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public boolean delete() {
        try {
            Files.delete(this.path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    boolean isSameFile(PathFileObject pathFileObject) {
        return this.path.equals(pathFileObject.path);
    }

    public boolean equals(Object object) {
        return object instanceof PathFileObject && this.path.equals(((PathFileObject)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.path + "]";
    }

    private void ensureParentDirectoriesExist() throws IOException {
        if (!this.hasParents) {
            Path path = this.path.getParent();
            if (path != null && !Files.isDirectory(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    throw new IOException("could not create parent directories", iOException);
                }
            }
            this.hasParents = true;
        }
    }

    protected static String toBinaryName(RelativePath relativePath) {
        return PathFileObject.toBinaryName(relativePath.path, "/");
    }

    protected static String toBinaryName(Path path) {
        return PathFileObject.toBinaryName(path.toString(), path.getFileSystem().getSeparator());
    }

    private static String toBinaryName(String string, String string2) {
        return PathFileObject.removeExtension(string).replace(string2, ".");
    }

    private static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getSimpleName(FileObject fileObject) {
        URI uRI = fileObject.toUri();
        String string = uRI.getSchemeSpecificPart();
        return string.substring(string.lastIndexOf("/") + 1);
    }

    public static class CannotCreateUriError
    extends Error {
        private static final long serialVersionUID = 9101708840997613546L;

        public CannotCreateUriError(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private static class SimpleFileObject
    extends PathFileObject {
        private final Path userPath;

        private SimpleFileObject(BaseFileManager baseFileManager, Path path, Path path2) {
            super(baseFileManager, path);
            this.userPath = path2;
        }

        @Override
        public String getName() {
            return this.userPath.toString();
        }

        @Override
        public String getShortName() {
            return this.userPath.getFileName().toString();
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> iterable) {
            Path path = this.path.toAbsolutePath();
            for (Path path2 : iterable) {
                Path path3 = path2.toAbsolutePath();
                if (!path.startsWith(path3)) continue;
                try {
                    Path path4 = path3.relativize(path);
                    if (path4 == null) continue;
                    return SimpleFileObject.toBinaryName(path4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            return null;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return BaseFileManager.getKind(this.userPath);
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return this.isPathNameCompatible(this.userPath, string, kind);
        }

        @Override
        PathFileObject getSibling(String string) {
            return new SimpleFileObject(this.fileManager, this.path.resolveSibling(string), this.userPath.resolveSibling(string));
        }
    }

    private static class JRTFileObject
    extends PathFileObject {
        private JRTFileObject(BaseFileManager baseFileManager, Path path) {
            super(baseFileManager, path);
        }

        @Override
        public String getName() {
            return this.path.toString();
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> iterable) {
            return JRTFileObject.toBinaryName(this.path.subpath(2, this.path.getNameCount()));
        }

        @Override
        public String toString() {
            return "JRTFileObject[" + this.path + "]";
        }

        @Override
        PathFileObject getSibling(String string) {
            return new JRTFileObject(this.fileManager, this.path.resolveSibling(string));
        }
    }

    private static class JarFileObject
    extends PathFileObject {
        private final Path userJarPath;

        private JarFileObject(BaseFileManager baseFileManager, Path path, Path path2) {
            super(baseFileManager, path);
            this.userJarPath = path2;
        }

        @Override
        public String getName() {
            return this.userJarPath + "(" + this.path + ")";
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> iterable) {
            Path path = this.path.getFileSystem().getRootDirectories().iterator().next();
            return JarFileObject.toBinaryName(path.relativize(this.path));
        }

        @Override
        public URI toUri() {
            return JarFileObject.createJarUri(this.userJarPath, this.path.toString());
        }

        @Override
        public String toString() {
            return "JarFileObject[" + this.userJarPath + ":" + this.path + "]";
        }

        @Override
        PathFileObject getSibling(String string) {
            return new JarFileObject(this.fileManager, this.path.resolveSibling(string), this.userJarPath);
        }

        private static URI createJarUri(Path path, String string) {
            URI uRI = path.toUri().normalize();
            String string2 = string.startsWith("/") ? "!" : "!/";
            try {
                return new URI("jar:" + uRI + string2 + string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new CannotCreateUriError(uRI + string2 + string, uRISyntaxException);
            }
        }
    }

    private static class DirectoryFileObject
    extends PathFileObject {
        private final Path userPackageRootDir;
        private final RelativePath relativePath;

        private DirectoryFileObject(BaseFileManager baseFileManager, Path path, Path path2, RelativePath relativePath) {
            super(baseFileManager, path);
            this.userPackageRootDir = Objects.requireNonNull(path2);
            this.relativePath = relativePath;
        }

        @Override
        public String getName() {
            return this.relativePath.resolveAgainst(this.userPackageRootDir).toString();
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> iterable) {
            return DirectoryFileObject.toBinaryName(this.relativePath);
        }

        @Override
        public String toString() {
            return "DirectoryFileObject[" + this.userPackageRootDir + ":" + this.relativePath.path + "]";
        }

        @Override
        PathFileObject getSibling(String string) {
            return new DirectoryFileObject(this.fileManager, this.path.resolveSibling(string), this.userPackageRootDir, new RelativePath.RelativeFile(this.relativePath.dirname(), string));
        }
    }
}

