/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nonapi.io.github.classgraph.classloaderhandler;

import java.net.URL;
import org.checkerframework.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import org.checkerframework.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import org.checkerframework.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import org.checkerframework.nonapi.io.github.classgraph.reflection.ReflectionUtils;
import org.checkerframework.nonapi.io.github.classgraph.scanspec.ScanSpec;
import org.checkerframework.nonapi.io.github.classgraph.utils.LogNode;

class JPMSClassLoaderHandler
implements ClassLoaderHandler {
    private JPMSClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "jdk.internal.loader.ClassLoaders$AppClassLoader".equals(classLoaderClass.getName()) || "jdk.internal.loader.BuiltinClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object ucpVal = ReflectionUtils.getFieldVal(false, (Object)classLoader, "ucp");
        if (ucpVal != null) {
            URL[] urls = (URL[])ReflectionUtils.invokeMethod(false, ucpVal, "getURLs");
            classpathOrder.addClasspathEntryObject(urls, classLoader, scanSpec, log);
        }
    }
}

