/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.google.common.graph;

import java.util.Objects;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.com.google.common.base.Preconditions;
import org.checkerframework.com.google.common.collect.ImmutableList;
import org.checkerframework.com.google.common.graph.DirectedMultiNetworkConnections;
import org.checkerframework.com.google.common.graph.DirectedNetworkConnections;
import org.checkerframework.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.checkerframework.com.google.common.graph.EndpointPair;
import org.checkerframework.com.google.common.graph.MutableNetwork;
import org.checkerframework.com.google.common.graph.NetworkBuilder;
import org.checkerframework.com.google.common.graph.NetworkConnections;
import org.checkerframework.com.google.common.graph.StandardNetwork;
import org.checkerframework.com.google.common.graph.UndirectedMultiNetworkConnections;
import org.checkerframework.com.google.common.graph.UndirectedNetworkConnections;
import org.checkerframework.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
final class StandardMutableNetwork<@SubstringIndexBottom N, @SubstringIndexBottom E>
extends StandardNetwork<N, E>
implements MutableNetwork<N, E> {
    StandardMutableNetwork(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super N, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super E> builder) {
        super(builder);
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean addNode(N node) {
        Preconditions.checkNotNull(node, "node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(node);
        return true;
    }

    @CanIgnoreReturnValue
    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkConnections<N, E> addNodeInternal(N node) {
        NetworkConnections<N, E> connections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(node, connections) == null);
        return connections;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean addEdge(N nodeU, N nodeV, E edge) {
        Preconditions.checkNotNull(nodeU, "nodeU");
        Preconditions.checkNotNull(nodeV, "nodeV");
        Preconditions.checkNotNull(edge, "edge");
        if (this.containsEdge(edge)) {
            EndpointPair existingIncidentNodes = this.incidentNodes(edge);
            EndpointPair<N> newIncidentNodes = EndpointPair.of(this, nodeU, nodeV);
            Preconditions.checkArgument(existingIncidentNodes.equals(newIncidentNodes), "Edge %s already exists between the following nodes: %s, so it cannot be reused to connect the following nodes: %s.", edge, existingIncidentNodes, newIncidentNodes);
            return false;
        }
        NetworkConnections<N, E> connectionsU = (NetworkConnections<N, E>)this.nodeConnections.get(nodeU);
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument(connectionsU == null || !connectionsU.successors().contains(nodeV), "Nodes %s and %s are already connected by a different edge. To construct a graph that allows parallel edges, call allowsParallelEdges(true) on the Builder.", nodeU, nodeV);
        }
        boolean isSelfLoop = nodeU.equals(nodeV);
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!isSelfLoop, "Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if (connectionsU == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        connectionsU.addOutEdge(edge, nodeV);
        NetworkConnections<N, E> connectionsV = (NetworkConnections<N, E>)this.nodeConnections.get(nodeV);
        if (connectionsV == null) {
            connectionsV = this.addNodeInternal(nodeV);
        }
        connectionsV.addInEdge(edge, nodeU, isSelfLoop);
        this.edgeToReferenceNode.put(edge, nodeU);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean addEdge(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed EndpointPair<N> endpoints, E edge) {
        this.validateEndpoints(endpoints);
        return this.addEdge(endpoints.nodeU(), endpoints.nodeV(), edge);
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean removeNode(N node) {
        Preconditions.checkNotNull(node, "node");
        NetworkConnections connections = (NetworkConnections)this.nodeConnections.get(node);
        if (connections == null) {
            return false;
        }
        for (Object edge : ImmutableList.copyOf(connections.incidentEdges())) {
            this.removeEdge(edge);
        }
        this.nodeConnections.remove(node);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean removeEdge(E edge) {
        Preconditions.checkNotNull(edge, "edge");
        Object nodeU = this.edgeToReferenceNode.get(edge);
        if (nodeU == null) {
            return false;
        }
        NetworkConnections connectionsU = Objects.requireNonNull((NetworkConnections)this.nodeConnections.get(nodeU));
        Object nodeV = connectionsU.adjacentNode(edge);
        NetworkConnections connectionsV = Objects.requireNonNull((NetworkConnections)this.nodeConnections.get(nodeV));
        connectionsU.removeOutEdge(edge);
        connectionsV.removeInEdge(edge, this.allowsSelfLoops() && nodeU.equals(nodeV));
        this.edgeToReferenceNode.remove(edge);
        return true;
    }

    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkConnections<N, E> newConnections() {
        return this.isDirected() ? (this.allowsParallelEdges() ? DirectedMultiNetworkConnections.of() : DirectedNetworkConnections.of()) : (this.allowsParallelEdges() ? UndirectedMultiNetworkConnections.of() : UndirectedNetworkConnections.of());
    }
}

