/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.google.common.collect;

import java.util.Comparator;
import java.util.SortedSet;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.SignednessBottom;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.com.google.common.annotations.GwtCompatible;
import org.checkerframework.com.google.common.base.Preconditions;
import org.checkerframework.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.checkerframework.com.google.common.collect.Ordering;
import org.checkerframework.com.google.common.collect.SortedIterable;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean hasSameComparator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Comparator<@SubstringIndexUnknown @SubstringIndexBottom @UnknownVal @BottomVal @SearchIndexUnknown @SearchIndexBottom @SameLenUnknown @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundUnknown @LowerBoundBottom @UpperBoundUnknown @UpperBoundBottom @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnknownSignedness @SignednessBottom ?> comparator, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterable<@SubstringIndexUnknown @SubstringIndexBottom @UnknownVal @BottomVal @SearchIndexUnknown @SearchIndexBottom @SameLenUnknown @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundUnknown @LowerBoundBottom @UpperBoundUnknown @UpperBoundBottom @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnknownSignedness @SignednessBottom ?> elements) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            comparator2 = SortedIterables.comparator((SortedSet)elements);
        } else if (elements instanceof SortedIterable) {
            comparator2 = ((SortedIterable)elements).comparator();
        } else {
            return false;
        }
        return comparator.equals(comparator2);
    }

    public static <E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Comparator<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super E> comparator(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed SortedSet<E> sortedSet) {
        Comparator<E> result = sortedSet.comparator();
        if (result == null) {
            result = Ordering.natural();
        }
        return result;
    }
}

