/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.org.objectweb.asm.AnnotationVisitor;
import org.checkerframework.org.objectweb.asm.ClassReader;
import org.checkerframework.org.objectweb.asm.ClassVisitor;
import org.checkerframework.org.objectweb.asm.FieldVisitor;
import org.checkerframework.org.objectweb.asm.MethodVisitor;

public class MethodRecorder
extends ClassVisitor {
    private List<String> methods = new ArrayList<String>();
    private List<String> annotations = new ArrayList<String>();
    private List<String> fields = new ArrayList<String>();

    public MethodRecorder(int api) {
        this(api, null);
    }

    public MethodRecorder(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.methods.add(name);
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.annotations.add(descriptor);
        return super.visitAnnotation(descriptor, visible);
    }

    public List<String> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public List<String> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public List<String> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.fields.add(name);
        return super.visitField(access, name, descriptor, signature, value);
    }

    public static void main(String[] args) throws IOException {
        ClassReader classReader = new ClassReader("org.checkerframework.com.google.common.annotations.GwtCompatible");
        MethodRecorder methodRecorder = new MethodRecorder(524288);
        classReader.accept(methodRecorder, 0);
        System.out.println(methodRecorder.annotations);
        System.out.println(methodRecorder.methods);
    }
}

