/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.tools;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.el.DefException;
import org.checkerframework.afu.scenelib.io.IndexFileParser;
import org.checkerframework.afu.scenelib.io.IndexFileWriter;
import org.checkerframework.afu.scenelib.io.JavapParser;
import org.checkerframework.afu.scenelib.io.classfile.ClassFileReader;
import org.checkerframework.afu.scenelib.io.classfile.ClassFileWriter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.org.plumelib.util.FileIOException;

public class Anncat {
    private Anncat() {
        throw new Error("Do not instantiate");
    }

    private static void usage() {
        System.err.println("anncat, part of the Annotation File Utilities");
        System.err.println("(https://checkerframework.org/annotation-file-utilities/)");
        System.err.println("usage: anncat <inspec>* [ --out <outspec> ], where:");
        System.err.println("    <inspec> ::=");
        System.err.println("        ( --javap <in.javap> )");
        System.err.println("        | ( --index <in.jaif> )");
        System.err.println("        | ( --class <in.class> )");
        System.err.println("    <outspec> ::=");
        System.err.println("        ( --index <out.jaif> )");
        System.err.println("        | ( --class [ --overwrite ] <orig.class> [ --to <out.class> ] )");
        System.err.println("If outspec is omitted, default is index file to stdout.");
    }

    private static void usageAssert(boolean b) {
        if (!b) {
            System.err.println("*** Usage error ***");
            Anncat.usage();
            System.exit(3);
        }
    }

    public static void main(String[] args) {
        block31: {
            Anncat.usageAssert(0 < args.length);
            if (args[0].equals("--help")) {
                Anncat.usage();
                System.exit(0);
            }
            try {
                int idx = 0;
                @NonNull AScene theScene = new AScene();
                while (idx < args.length && !args[idx].equals("--out")) {
                    String infile;
                    if (args[idx].equals("--javap")) {
                        Anncat.usageAssert(++idx < args.length);
                        infile = args[idx++];
                        System.out.println("Reading javap file " + infile + "...");
                        JavapParser.parse(infile, theScene);
                        System.out.println("Finished.");
                        continue;
                    }
                    if (args[idx].equals("--index")) {
                        Anncat.usageAssert(++idx < args.length);
                        infile = args[idx++];
                        System.err.println("Reading index file " + infile + "...");
                        IndexFileParser.parseFile(infile, theScene);
                        System.err.println("Finished.");
                        continue;
                    }
                    if (args[idx].equals("--class")) {
                        Anncat.usageAssert(++idx < args.length);
                        infile = args[idx++];
                        System.err.println("Reading class file " + infile + "...");
                        ClassFileReader.read(theScene, infile);
                        System.err.println("Finished.");
                        continue;
                    }
                    Anncat.usageAssert(false);
                }
                if (idx == args.length) {
                    System.err.println("Writing index file to standard output...");
                    IndexFileWriter.write(theScene, new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
                    System.err.println("Finished.");
                    break block31;
                }
                Anncat.usageAssert(++idx < args.length);
                if (args[idx].equals("--index")) {
                    Anncat.usageAssert(++idx < args.length);
                    String outfile = args[idx];
                    Anncat.usageAssert(++idx == args.length);
                    System.err.println("Writing index file to " + outfile + "...");
                    try (BufferedWriter w = Files.newBufferedWriter(Paths.get(outfile, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                        IndexFileWriter.write(theScene, w);
                    }
                    System.err.println("Finished.");
                    break block31;
                }
                if (args[idx].equals("--class")) {
                    boolean overwrite;
                    Anncat.usageAssert(++idx < args.length);
                    if (args[idx].equals("--overwrite")) {
                        System.err.println("Overwrite mode enabled.");
                        overwrite = true;
                        Anncat.usageAssert(++idx < args.length);
                    } else {
                        overwrite = false;
                    }
                    String origfile = args[idx];
                    if (++idx < args.length) {
                        Anncat.usageAssert(args[idx].equals("--to"));
                        Anncat.usageAssert(++idx < args.length);
                        String outfile = args[idx];
                        Anncat.usageAssert(++idx == args.length);
                        System.err.println("Reading original class file " + origfile);
                        System.err.println("and writing annotated version to " + outfile + "...");
                        try (FileInputStream fis = new FileInputStream(origfile);
                             FileOutputStream fos = new FileOutputStream(outfile);){
                            ClassFileWriter.insert(theScene, fis, fos, overwrite);
                        }
                        System.err.println("Finished.");
                        break block31;
                    }
                    System.err.println("Rewriting class file " + origfile + " with annotations...");
                    ClassFileWriter.insert(theScene, null, origfile, overwrite);
                    System.err.println("Finished.");
                    break block31;
                }
                Anncat.usageAssert(false);
            }
            catch (FileIOException e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                System.exit(2);
            }
            catch (DefException e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

