/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io.classfile;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.AnnotationBuilder;
import org.checkerframework.afu.scenelib.AnnotationFactory;
import org.checkerframework.afu.scenelib.Annotations;
import org.checkerframework.afu.scenelib.ArrayBuilder;
import org.checkerframework.afu.scenelib.el.AClass;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.AnnotationDef;
import org.checkerframework.afu.scenelib.el.BoundLocation;
import org.checkerframework.afu.scenelib.el.LocalLocation;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.afu.scenelib.el.TypeIndexLocation;
import org.checkerframework.afu.scenelib.el.TypePathEntry;
import org.checkerframework.afu.scenelib.field.AnnotationAFT;
import org.checkerframework.afu.scenelib.field.ArrayAFT;
import org.checkerframework.afu.scenelib.field.BasicAFT;
import org.checkerframework.afu.scenelib.field.ClassTokenAFT;
import org.checkerframework.afu.scenelib.field.EnumAFT;
import org.checkerframework.afu.scenelib.field.ScalarAFT;
import org.checkerframework.afu.scenelib.io.classfile.CodeOffsetAdapter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;

public class ClassAnnotationSceneReader
extends CodeOffsetAdapter {
    private static final boolean trace = false;
    private static final boolean strict = false;
    private final boolean ignoreBridgeMethods;
    private final AScene scene;
    private AClass aClass;
    private final ClassReader classReader;
    private final ClassWriter classWriter;
    private final Map<String, AnnotationDef> annotationDefinitions = ClassAnnotationSceneReader.initialiseAnnotationDefinitions();
    String dummyDesc = "dummy";

    private static Map<String, AnnotationDef> initialiseAnnotationDefinitions() {
        HashMap<String, AnnotationDef> result = new HashMap<String, AnnotationDef>();
        for (AnnotationDef ad : Annotations.standardDefs) {
            result.put(ad.name, ad);
        }
        return result;
    }

    public ClassAnnotationSceneReader(int api, ClassReader classReader, AScene scene, boolean ignoreBridgeMethods) {
        super(api, classReader);
        this.classReader = classReader;
        this.classWriter = new ClassWriter(this.classReader, api);
        this.cv = this.classWriter;
        this.scene = scene;
        this.ignoreBridgeMethods = ignoreBridgeMethods;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classWriter.visit(version, access, name, signature, superName, interfaces);
        this.aClass = this.scene.classes.getVivify(name.replace('/', '.'));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationWriter = this.classWriter.visitAnnotation(descriptor, visible);
        return new AnnotationSceneReader(this.api, descriptor, visible, this.aClass, annotationWriter);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationWriter = this.classWriter.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        return new TypeAnnotationSceneReader(this.api, descriptor, visible, this.aClass, annotationWriter, typeRef, typePath, null, null, null, null);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        AField aField = this.aClass.fields.getVivify(name);
        FieldVisitor fieldWriter = this.classWriter.visitField(access, name, descriptor, signature, value);
        return new FieldAnnotationSceneReader(this.api, aField, fieldWriter);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.ignoreBridgeMethods && (access & 0x40) != 0) {
            return null;
        }
        AMethod aMethod = this.aClass.methods.getVivify(name + descriptor);
        MethodVisitor methodWriter = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodAnnotationSceneReader(this.api, aMethod, methodWriter);
    }

    private static @ClassGetName String classDescToName(String descriptor) {
        assert (descriptor.startsWith("L"));
        assert (descriptor.endsWith(";"));
        return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
    }

    private static void printClasspath() {
        System.out.println();
        System.out.println("Classpath:");
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            System.out.println("  " + tokenizer.nextToken());
        }
    }

    private class AnnotationSceneReader
    extends AnnotationVisitor {
        protected AElement aElement;
        protected boolean visible;
        private AnnotationBuilder annotationBuilder;
        protected AnnotationVisitor annotationWriter;
        protected int savedOffset;

        private AnnotationDef getAnnotationDef(String jvmlClassName) {
            Class<?> annoClass;
            String annoTypeName = ClassAnnotationSceneReader.classDescToName(jvmlClassName);
            try {
                annoClass = Class.forName(annoTypeName);
            }
            catch (ClassNotFoundException e) {
                if (annoTypeName.contains("+")) {
                    String annoTypeName2 = annoTypeName;
                    return Annotations.createValueAnnotationDef(annoTypeName2, Annotations.noAnnotations, BasicAFT.forType(Integer.TYPE), String.format("Could not find class %s: %s", jvmlClassName, e.getMessage()));
                }
                System.out.printf("Could not find class: %s%n", e.getMessage());
                ClassAnnotationSceneReader.printClasspath();
                throw new Error(e);
            }
            AnnotationDef ad = AnnotationDef.fromClass(annoClass, ClassAnnotationSceneReader.this.annotationDefinitions);
            return ad;
        }

        AnnotationSceneReader(int api, String descriptor, boolean visible, AElement aElement, AnnotationVisitor annotationWriter) {
            super(api, annotationWriter);
            this.visible = visible;
            this.aElement = aElement;
            this.annotationWriter = annotationWriter;
            if (descriptor != ClassAnnotationSceneReader.this.dummyDesc) {
                AnnotationDef ad = this.getAnnotationDef(descriptor);
                AnnotationBuilder ab = AnnotationFactory.saf.beginAnnotation(ad, "TODO: ClassAnnotationSceneReader");
                if (ab == null) {
                    throw new IllegalArgumentException("bad descriptor: " + descriptor);
                }
                this.annotationBuilder = ab;
            }
        }

        @Override
        public void visit(String name, Object value) {
            Class<Object> c = value.getClass();
            if (c.equals(Boolean.class)) {
                c = Boolean.TYPE;
            } else if (c.equals(Byte.class)) {
                c = Byte.TYPE;
            } else if (c.equals(Character.class)) {
                c = Character.TYPE;
            } else if (c.equals(Short.class)) {
                c = Short.TYPE;
            } else if (c.equals(Integer.class)) {
                c = Integer.TYPE;
            } else if (c.equals(Long.class)) {
                c = Long.TYPE;
            } else if (c.equals(Float.class)) {
                c = Float.TYPE;
            } else if (c.equals(Double.class)) {
                c = Double.TYPE;
            } else {
                if (c.equals(Type.class)) {
                    try {
                        this.annotationBuilder.addScalarField(name, ClassTokenAFT.ctaft, Class.forName(((Type)value).getClassName()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Could not load Class for Type: " + value, e);
                    }
                    return;
                }
                if (!c.equals(String.class)) {
                    c = c.getComponentType();
                    ArrayBuilder arrayBuilder = this.annotationBuilder.beginArrayField(name, new ArrayAFT(BasicAFT.forType(c)));
                    for (Object o : this.asList(value)) {
                        arrayBuilder.appendElement(o);
                    }
                    arrayBuilder.finish();
                    return;
                }
            }
            this.annotationBuilder.addScalarField(name, BasicAFT.forType(c), value);
        }

        private List<Object> asList(Object primitiveArray) {
            ArrayList<Object> objects = new ArrayList<Object>();
            Class<?> c = primitiveArray.getClass().getComponentType();
            if (c.equals(Boolean.TYPE)) {
                for (boolean o : (boolean[])primitiveArray) {
                    objects.add(o);
                }
            } else if (c.equals(Byte.TYPE)) {
                for (byte o : (byte[])primitiveArray) {
                    objects.add(o);
                }
            } else if (c.equals(Character.TYPE)) {
                for (char o : (char[])primitiveArray) {
                    objects.add(Character.valueOf(o));
                }
            } else if (c.equals(Short.TYPE)) {
                for (short o : (short[])primitiveArray) {
                    objects.add(o);
                }
            } else if (c.equals(Integer.TYPE)) {
                for (int o : (int[])primitiveArray) {
                    objects.add(o);
                }
            } else if (c.equals(Long.TYPE)) {
                for (long o : (long[])primitiveArray) {
                    objects.add(o);
                }
            } else if (c.equals(Float.TYPE)) {
                for (float o : (float[])primitiveArray) {
                    objects.add(Float.valueOf(o));
                }
            } else if (c.equals(Double.TYPE)) {
                for (double o : (double[])primitiveArray) {
                    objects.add(o);
                }
            } else {
                throw new RuntimeException("Array has non-primitive type " + c + ": " + primitiveArray);
            }
            return objects;
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            this.annotationBuilder.addScalarField(name, new EnumAFT(descriptor), value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            AnnotationVisitor annotationWriter = this.annotationWriter.visitAnnotation(name, descriptor);
            return new NestedAnnotationSceneReader(this.api, this, name, descriptor, annotationWriter);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor annotationWriter = this.annotationWriter.visitArray(name);
            return new ArrayAnnotationSceneReader(this.api, this, name, annotationWriter);
        }

        protected void saveOffset(int offset) {
            this.savedOffset = offset;
        }

        @Override
        public void visitEnd() {
            this.annotationWriter.visitEnd();
            Annotation a = this.makeAnnotation();
            if (a.def.isTypeAnnotation() && this.aElement instanceof AMethod) {
                AMethod m = (AMethod)this.aElement;
                m.returnType.tlAnnotationsHere.add(a);
            } else {
                this.aElement.tlAnnotationsHere.add(a);
            }
        }

        Annotation makeAnnotation() {
            return this.annotationBuilder.finish();
        }

        void supplySubannotation(String fieldName, Annotation annotation) {
            this.annotationBuilder.addScalarField(fieldName, new AnnotationAFT(annotation.def()), annotation);
        }

        public String toString() {
            return String.format("(AnnotationSceneReader: %s %s %s)", this.aElement, this.visible, this.annotationBuilder);
        }
    }

    private class TypeAnnotationSceneReader
    extends AnnotationSceneReader {
        private final TypeReference typeReference;
        private final TypePath typePath;
        private final Label[] start;
        private final Label[] end;
        private final int[] index;
        private final @Nullable String localVariableName;

        TypeAnnotationSceneReader(int api, String descriptor, boolean visible, AElement aElement, AnnotationVisitor annotationWriter, int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index) {
            this(api, descriptor, visible, aElement, annotationWriter, typeRef, typePath, start, end, index, null);
        }

        TypeAnnotationSceneReader(int api, String descriptor, boolean visible, AElement aElement, AnnotationVisitor annotationWriter, int typeRef, TypePath typePath, Label[] start, Label[] end, int @Nullable [] index, String localVariableName) {
            super(api, descriptor, visible, aElement, annotationWriter);
            this.typeReference = new TypeReference(typeRef);
            this.typePath = typePath;
            this.start = start;
            this.end = end;
            this.index = index;
            if (this.typeReference.getSort() != 64 && this.typeReference.getSort() != 65 && (start != null || end != null || index != null)) {
                System.err.printf("Error: LOCAL_VARIABLE and RESOURCE_VARIABLE TypeReference with start = %s, end = %s, index = %s", Arrays.toString(start), Arrays.toString(end), Arrays.toString(index));
            }
            this.localVariableName = localVariableName;
        }

        @Override
        public void visitEnd() {
            this.annotationWriter.visitEnd();
            try {
                switch (this.typeReference.getSort()) {
                    case 17: {
                        this.handleClassTypeParameterBound((AClass)this.aElement);
                        break;
                    }
                    case 0: {
                        this.handleClassTypeParameter((AClass)this.aElement);
                        break;
                    }
                    case 16: {
                        this.handleClassExtends((AClass)this.aElement);
                        break;
                    }
                    case 19: {
                        this.handleField(this.aElement);
                        break;
                    }
                    case 64: 
                    case 65: {
                        if (this.aElement instanceof AMethod) {
                            this.handleMethodLocalVariable((AMethod)this.aElement);
                        }
                        break;
                    }
                    case 68: {
                        if (this.aElement instanceof AMethod) {
                            this.handleMethodObjectCreation((AMethod)this.aElement);
                        }
                        break;
                    }
                    case 22: {
                        this.handleMethodFormalParameter((AMethod)this.aElement);
                        break;
                    }
                    case 21: {
                        this.handleMethodReceiver((AMethod)this.aElement);
                        break;
                    }
                    case 71: {
                        if (this.aElement instanceof AMethod) {
                            this.handleMethodTypecast((AMethod)this.aElement);
                        }
                        break;
                    }
                    case 20: {
                        this.handleMethodReturnType((AMethod)this.aElement);
                        break;
                    }
                    case 67: {
                        if (this.aElement instanceof AMethod) {
                            this.handleMethodInstanceOf((AMethod)this.aElement);
                        }
                        break;
                    }
                    case 18: {
                        this.handleMethodTypeParameterBound((AMethod)this.aElement);
                        break;
                    }
                    case 23: {
                        this.handleThrows((AMethod)this.aElement);
                        break;
                    }
                    case 69: 
                    case 70: {
                        this.handleMethodReference((AMethod)this.aElement);
                        break;
                    }
                    case 74: 
                    case 75: {
                        this.handleReferenceTypeArgument((AMethod)this.aElement);
                        break;
                    }
                    case 72: 
                    case 73: {
                        this.handleInvocationTypeArgument((AMethod)this.aElement);
                        break;
                    }
                    case 1: {
                        this.handleMethodTypeParameter((AMethod)this.aElement);
                        break;
                    }
                    case 66: {
                        throw new Error("EXCEPTION_PARAMETER TypeReference case.");
                    }
                    default: {
                        throw new RuntimeException("Unknown TypeReference: " + this.typeReference.getSort());
                    }
                }
            }
            catch (ClassCastException e) {
                System.err.println("Exception trace: " + e.getMessage());
                System.err.println("Classfile is malformed. Ignoring this type annotation.");
                System.err.println("    This AElement: " + this.aElement);
                System.err.println("    This TypeReference: " + this.typeReference.getValue());
            }
        }

        private void handleClassTypeParameter(AClass aClass) {
            aClass.bounds.getVivify((BoundLocation)this.makeBoundLocation()).tlAnnotationsHere.add(this.makeAnnotation());
        }

        private void handleClassTypeParameterBound(AClass aClass) {
            if (this.typePath == null) {
                aClass.bounds.getVivify((BoundLocation)this.makeBoundLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aClass.bounds.getVivify((BoundLocation)this.makeBoundLocation()).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleClassExtends(AClass aClass) {
            TypeIndexLocation typeIndexLocation = new TypeIndexLocation(this.typeReference.getSuperTypeIndex());
            if (this.typePath == null) {
                aClass.extendsImplements.getVivify((TypeIndexLocation)typeIndexLocation).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aClass.extendsImplements.getVivify((TypeIndexLocation)typeIndexLocation).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleField(AElement aElement) {
            if (!(aElement instanceof AClass)) {
                if (aElement instanceof ATypeElement) {
                    ATypeElement aTypeElement = (ATypeElement)aElement;
                    if (this.typePath == null) {
                        aTypeElement.tlAnnotationsHere.add(this.makeAnnotation());
                    } else {
                        aTypeElement.innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
                    }
                } else {
                    throw new RuntimeException("Unknown FIELD_COMPONENT: " + aElement);
                }
            }
        }

        private void handleMethodFormalParameter(AMethod aMethod) {
            if (this.typePath == null) {
                aMethod.parameters.getVivify((Integer)Integer.valueOf((int)this.typeReference.getFormalParameterIndex())).type.tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.parameters.getVivify((Integer)Integer.valueOf((int)this.typeReference.getFormalParameterIndex())).type.innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodTypeParameter(AMethod aMethod) {
            aMethod.bounds.getVivify((BoundLocation)this.makeBoundLocation()).tlAnnotationsHere.add(this.makeAnnotation());
        }

        private void handleMethodTypeParameterBound(AMethod aMethod) {
            if (this.typePath == null) {
                aMethod.bounds.getVivify((BoundLocation)this.makeBoundLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.bounds.getVivify((BoundLocation)this.makeBoundLocation()).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodReturnType(AMethod aMethod) {
            if (this.typePath == null) {
                aMethod.returnType.tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.returnType.innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodReceiver(AMethod aMethod) {
            if (this.typePath == null) {
                aMethod.receiver.type.tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.receiver.type.innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleThrows(AMethod aMethod) {
            TypeIndexLocation typeIndexLocation = new TypeIndexLocation(this.typeReference.getExceptionIndex());
            aMethod.throwsException.getVivify((TypeIndexLocation)typeIndexLocation).tlAnnotationsHere.add(this.makeAnnotation());
        }

        private void handleMethodObjectCreation(AMethod aMethod) {
            this.saveOffset(ClassAnnotationSceneReader.this.getPreviousCodeOffset());
            if (this.typePath == null) {
                ((ATypeElement)aMethod.body.news.getVivify(this.makeOffset((boolean)false))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.news.getVivify(this.makeOffset((boolean)false))).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodInstanceOf(AMethod aMethod) {
            this.saveOffset(ClassAnnotationSceneReader.this.getPreviousCodeOffset());
            if (this.typePath == null) {
                ((ATypeElement)aMethod.body.instanceofs.getVivify(this.makeOffset((boolean)false))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.instanceofs.getVivify(this.makeOffset((boolean)false))).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodReference(AMethod aMethod) {
            if (this.typePath == null) {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)false))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)false))).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodTypecast(AMethod aMethod) {
            this.saveOffset(ClassAnnotationSceneReader.this.getPreviousCodeOffset());
            if (this.typePath == null) {
                ((ATypeElement)aMethod.body.typecasts.getVivify(this.makeOffset((boolean)true))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.typecasts.getVivify(this.makeOffset((boolean)true))).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleInvocationTypeArgument(AMethod aMethod) {
            if (this.typePath == null) {
                ((ATypeElement)aMethod.body.calls.getVivify(this.makeOffset((boolean)true))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.calls.getVivify(this.makeOffset((boolean)true))).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleReferenceTypeArgument(AMethod aMethod) {
            if (this.typePath == null) {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)true))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)true))).innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodLocalVariable(AMethod aMethod) {
            if (this.typePath == null) {
                aMethod.body.locals.getVivify((LocalLocation)this.makeLocalLocation()).type.tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.body.locals.getVivify((LocalLocation)this.makeLocalLocation()).type.innerTypes.getVivify(TypePathEntry.typePathToList((TypePath)this.typePath)).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private LocalLocation makeLocalLocation() {
            return new LocalLocation(this.start, this.end, this.index, this.localVariableName);
        }

        private RelativeLocation makeOffset(boolean needTypeIndex) {
            int typeIndex = needTypeIndex ? this.typeReference.getTypeArgumentIndex() : -1;
            return RelativeLocation.createOffset(this.savedOffset, typeIndex);
        }

        private BoundLocation makeBoundLocation() {
            return this.typeReference.getSort() == 17 || this.typeReference.getSort() == 18 ? new BoundLocation(this.typeReference.getTypeParameterIndex(), this.typeReference.getTypeParameterBoundIndex()) : new BoundLocation(this.typeReference.getTypeParameterIndex(), -1);
        }

        @Override
        public String toString() {
            return "TypeAnnotationSceneReader{aElement=" + this.aElement + ", visible=" + this.visible + ", typeReference=" + this.typeReference + ", typePath=" + this.typePath + ", start=" + Arrays.toString(this.start) + ", end=" + Arrays.toString(this.end) + ", index=" + Arrays.toString(this.index) + ", localVariableName=" + this.localVariableName + '}';
        }
    }

    private class FieldAnnotationSceneReader
    extends FieldVisitor {
        private final AElement aField;
        private final FieldVisitor fieldWriter;

        FieldAnnotationSceneReader(int api, AElement aField, FieldVisitor fieldWriter) {
            super(api, fieldWriter);
            this.aField = aField;
            this.fieldWriter = fieldWriter;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.fieldWriter.visitAnnotation(descriptor, visible);
            return new AnnotationSceneReader(this.api, descriptor, visible, this.aField, annotationWriter);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.fieldWriter.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
            return new TypeAnnotationSceneReader(this.api, descriptor, visible, this.aField.type, annotationWriter, typeRef, typePath, null, null, null, null);
        }
    }

    private class MethodAnnotationSceneReader
    extends MethodVisitor {
        private final AElement aMethod;
        private final MethodVisitor methodWriter;
        private String localVariableName;

        MethodAnnotationSceneReader(int api, AElement aMethod, MethodVisitor methodWriter) {
            super(api, methodWriter);
            this.aMethod = aMethod;
            this.methodWriter = methodWriter;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.methodWriter.visitAnnotation(descriptor, visible);
            return new AnnotationSceneReader(this.api, descriptor, visible, this.aMethod, annotationWriter);
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.methodWriter.visitParameterAnnotation(parameter, descriptor, visible);
            return new AnnotationSceneReader(this.api, descriptor, visible, ((AMethod)this.aMethod).parameters.getVivify(parameter), annotationWriter);
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
            this.localVariableName = name;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.methodWriter.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
            return new TypeAnnotationSceneReader(this.api, descriptor, visible, this.aMethod, annotationWriter, typeRef, typePath, null, null, null);
        }

        @Override
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.methodWriter.visitInsnAnnotation(typeRef, typePath, descriptor, visible);
            return new TypeAnnotationSceneReader(this.api, descriptor, visible, this.aMethod, annotationWriter, typeRef, typePath, null, null, null);
        }

        @Override
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.methodWriter.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible);
            return new TypeAnnotationSceneReader(this.api, descriptor, visible, this.aMethod, annotationWriter, typeRef, typePath, null, null, null);
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
            AnnotationVisitor annotationWriter = this.methodWriter.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, descriptor, visible);
            return new TypeAnnotationSceneReader(this.api, descriptor, visible, this.aMethod, annotationWriter, typeRef, typePath, start, end, index, this.localVariableName);
        }
    }

    private class ArrayAnnotationSceneReader
    extends AnnotationSceneReader {
        private final AnnotationSceneReader parent;
        private ArrayBuilder arrayBuilder;
        private final String arrayName;

        ArrayAnnotationSceneReader(int api, AnnotationSceneReader parent, String fieldName, AnnotationVisitor annotationWriter) {
            super(api, ClassAnnotationSceneReader.this.dummyDesc, parent.visible, parent.aElement, annotationWriter);
            this.parent = parent;
            this.arrayName = fieldName;
            this.arrayBuilder = null;
        }

        private void prepareForElement(ScalarAFT elementType) {
            assert (elementType != null);
            if (this.arrayBuilder == null) {
                this.arrayBuilder = this.parent.annotationBuilder.beginArrayField(this.arrayName, new ArrayAFT(elementType));
            }
        }

        @Override
        public void visit(String name, Object value) {
            ScalarAFT aft;
            this.annotationWriter.visit(name, value);
            if (value.getClass().equals(Type.class)) {
                aft = ClassTokenAFT.ctaft;
                try {
                    value = Class.forName(((Type)((Object)value)).getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load Class for Type: " + value, e);
                }
            } else {
                Class<?> vc = value.getClass();
                aft = BasicAFT.forType(vc);
            }
            assert (aft != null);
            this.prepareForElement(aft);
            assert (this.arrayBuilder != null);
            this.arrayBuilder.appendElement(value);
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            this.annotationWriter.visitEnum(name, descriptor, value);
            this.prepareForElement(new EnumAFT(ClassAnnotationSceneReader.classDescToName(descriptor)));
            assert (this.arrayBuilder != null);
            this.arrayBuilder.appendElement(value);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            this.annotationWriter.visitArray(name);
            throw new AssertionError((Object)"Multidimensional array in annotation!");
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            AnnotationVisitor annotationWriter = this.annotationWriter.visitAnnotation(name, descriptor);
            return new NestedAnnotationSceneReader(this.api, this, name, descriptor, annotationWriter);
        }

        @Override
        public void visitEnd() {
            this.annotationWriter.visitEnd();
            if (this.arrayBuilder != null) {
                this.arrayBuilder.finish();
            } else {
                this.parent.annotationBuilder.addEmptyArrayField(this.arrayName);
            }
        }

        @Override
        void supplySubannotation(String fieldName, Annotation annotation) {
            this.prepareForElement(new AnnotationAFT(annotation.def()));
            assert (this.arrayBuilder != null);
            this.arrayBuilder.appendElement(annotation);
        }
    }

    private class NestedAnnotationSceneReader
    extends AnnotationSceneReader {
        private final AnnotationSceneReader parent;
        private final String name;

        NestedAnnotationSceneReader(int api, AnnotationSceneReader parent, String name, String descriptor, AnnotationVisitor annotationWriter) {
            super(api, descriptor, parent.visible, parent.aElement, annotationWriter);
            this.parent = parent;
            this.name = name;
        }

        @Override
        public void visitEnd() {
            this.annotationWriter.visitEnd();
            Annotation a = super.makeAnnotation();
            this.parent.supplySubannotation(this.name, a);
        }
    }
}

