/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.afu.annotator.find.CaseUtils;
import org.checkerframework.afu.scenelib.io.ASTIndex;
import org.checkerframework.afu.scenelib.io.DebugWriter;
import org.checkerframework.afu.scenelib.io.ImmutableStack;
import org.checkerframework.afu.scenelib.io.ParseException;
import org.plumelib.util.ArraysPlume;

public class ASTPath
extends ImmutableStack<ASTEntry>
implements Comparable<ASTPath>,
Iterable<ASTEntry> {
    private static final ASTPath EMPTY = new ASTPath();
    private static final String[] typeSelectors = new String[]{"bound", "identifier", "type", "typeAlternative", "typeArgument", "typeParameter", "underlyingType"};
    public static final String ANNOTATION = "annotation";
    public static final String ARGUMENT = "argument";
    public static final String BLOCK = "block";
    public static final String BODY = "body";
    public static final String BOUND = "bound";
    public static final String CASE = "case";
    public static final String CATCH = "catch";
    public static final String CLASS_BODY = "classBody";
    public static final String CONDITION = "condition";
    public static final String DETAIL = "detail";
    public static final String DIMENSION = "dimension";
    public static final String ELSE_STATEMENT = "elseStatement";
    public static final String ENCLOSING_EXPRESSION = "enclosingExpression";
    public static final String EXPRESSION = "expression";
    public static final String FALSE_EXPRESSION = "falseExpression";
    public static final String FINALLY_BLOCK = "finallyBlock";
    public static final String IDENTIFIER = "identifier";
    public static final String INDEX = "index";
    public static final String INITIALIZER = "initializer";
    public static final String LEFT_OPERAND = "leftOperand";
    public static final String METHOD_SELECT = "methodSelect";
    public static final String MODIFIERS = "modifiers";
    public static final String PARAMETER = "parameter";
    public static final String QUALIFIER_EXPRESSION = "qualifierExpression";
    public static final String RESOURCE = "resource";
    public static final String RIGHT_OPERAND = "rightOperand";
    public static final String STATEMENT = "statement";
    public static final String THEN_STATEMENT = "thenStatement";
    public static final String THROWS = "throws";
    public static final String TRUE_EXPRESSION = "trueExpression";
    public static final String TYPE = "type";
    public static final String TYPE_ALTERNATIVE = "typeAlternative";
    public static final String TYPE_ARGUMENT = "typeArgument";
    public static final String TYPE_PARAMETER = "typeParameter";
    public static final String UNDERLYING_TYPE = "underlyingType";
    public static final String UPDATE = "update";
    public static final String VARIABLE = "variable";
    private static Comparator<ASTPath> comparator = new Comparator<ASTPath>(){

        @Override
        public int compare(ASTPath p1, ASTPath p2) {
            return p1 == null ? (p2 == null ? 0 : -1) : p1.compareTo(p2);
        }
    };

    ASTPath() {
    }

    public static ASTPath empty() {
        return EMPTY;
    }

    public static Comparator<ASTPath> getComparator() {
        return comparator;
    }

    @Override
    public Iterator<ASTEntry> iterator() {
        ImmutableStack s = this;
        int n = this.size();
        ASTEntry[] a = new ASTEntry[n];
        while (--n >= 0) {
            a[n] = (ASTEntry)((ImmutableStack)s).peek();
            s = ((ImmutableStack)s).pop();
        }
        return Arrays.asList(a).iterator();
    }

    public ASTPath extendNewArray(int depth) {
        return this.extend(new ASTEntry(Tree.Kind.NEW_ARRAY, TYPE, depth));
    }

    public ASTPath newArrayLevel(int depth) {
        return this.add(new ASTEntry(Tree.Kind.NEW_ARRAY, TYPE, depth));
    }

    public ASTPath add(ASTEntry entry) {
        ASTPath path = EMPTY;
        for (ASTEntry e : this) {
            path = path.extend(e);
        }
        return path.extend(entry);
    }

    public ASTPath extend(ASTEntry entry) {
        return (ASTPath)this.push(entry);
    }

    public ASTPath getParentPath() {
        return (ASTPath)this.pop();
    }

    public ASTEntry getLast() {
        return (ASTEntry)this.peek();
    }

    private static ASTPath canonical(ASTPath astPath) {
        return astPath;
    }

    public static ASTPath parse(String s) throws ParseException {
        return new Parser(s).parseASTPath();
    }

    public boolean matches(TreePath treePath) {
        CompilationUnitTree cut = treePath.getCompilationUnit();
        Tree leaf = treePath.getLeaf();
        ASTPath astPath = ASTIndex.indexOf((CompilationUnitTree)cut).get((Object)leaf).astPath;
        return this.equals(astPath);
    }

    public static boolean isTypeSelector(String selector) {
        return Arrays.binarySearch(typeSelectors, selector, Collator.getInstance()) >= 0;
    }

    public static boolean isClassEquiv(Tree.Kind kind) {
        return kind.asInterface().equals(ClassTree.class);
    }

    public static boolean isCompoundAssignment(Tree.Kind kind) {
        return kind.asInterface().equals(CompoundAssignmentTree.class);
    }

    public static boolean isUnaryOperator(Tree.Kind kind) {
        return kind.asInterface().equals(UnaryTree.class);
    }

    public static boolean isBinaryOperator(Tree.Kind kind) {
        return kind.asInterface().equals(BinaryTree.class);
    }

    public static boolean isLiteral(Tree.Kind kind) {
        return kind.asInterface().equals(LiteralTree.class);
    }

    public static boolean isTypeKind(Tree.Kind kind) {
        switch (kind) {
            case ANNOTATED_TYPE: 
            case ARRAY_TYPE: 
            case PARAMETERIZED_TYPE: 
            case UNION_TYPE: 
            case IDENTIFIER: 
            case INTERSECTION_TYPE: 
            case PRIMITIVE_TYPE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWildcard(Tree.Kind kind) {
        return kind.asInterface().equals(WildcardTree.class);
    }

    public static boolean isDeclaration(Tree.Kind kind) {
        return kind == Tree.Kind.ANNOTATION || kind == Tree.Kind.CLASS || kind == Tree.Kind.ENUM || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.METHOD || kind == Tree.Kind.VARIABLE;
    }

    public static boolean isHandled(Tree.Kind kind) {
        switch (kind) {
            case BREAK: 
            case COMPILATION_UNIT: 
            case CONTINUE: 
            case IMPORT: 
            case MODIFIERS: {
                return false;
            }
        }
        return !ASTPath.isDeclaration(kind);
    }

    public int hashCode() {
        ImmutableStack s = ASTPath.canonical(this);
        int hash = 0;
        while (!((ImmutableStack)s).isEmpty()) {
            hash = Integer.rotateRight(hash ^ ((ASTEntry)((ImmutableStack)s).peek()).hashCode(), 1);
            s = ((ImmutableStack)s).pop();
        }
        return hash;
    }

    public boolean equals(Object o) {
        return o instanceof ASTPath && this.equals((ASTPath)o);
    }

    public boolean equals(ASTPath astPath) {
        return this.compareTo(astPath) == 0;
    }

    @Override
    public int compareTo(ASTPath o) {
        int n1;
        ImmutableStack s0 = ASTPath.canonical(this);
        ImmutableStack s1 = ASTPath.canonical(o);
        LinkedList<ASTEntry> d0 = new LinkedList<ASTEntry>();
        LinkedList<ASTEntry> d1 = new LinkedList<ASTEntry>();
        while (!((ImmutableStack)s0).isEmpty()) {
            d0.push((ASTEntry)((ImmutableStack)s0).peek());
            s0 = ((ImmutableStack)s0).pop();
        }
        while (!((ImmutableStack)s1).isEmpty()) {
            d1.push((ASTEntry)((ImmutableStack)s1).peek());
            s1 = ((ImmutableStack)s1).pop();
        }
        int n0 = d0.size();
        int c = Integer.compare(n0, n1 = d1.size());
        if (c == 0) {
            Iterator i0 = d0.iterator();
            Iterator i1 = d1.iterator();
            while (i0.hasNext()) {
                c = ((ASTEntry)i0.next()).compareTo((ASTEntry)i1.next());
                if (c == 0) continue;
                return c;
            }
        }
        return c;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        Iterator<ASTEntry> iter = this.iterator();
        StringBuilder sb = new StringBuilder().append(iter.next());
        while (iter.hasNext()) {
            sb = sb.append(", ").append(iter.next());
        }
        return sb.toString();
    }

    public static class ASTEntry
    implements Comparable<ASTEntry> {
        private Tree.Kind treeKind;
        private String childSelector;
        private Integer argument;

        public ASTEntry(Tree.Kind treeKind, String childSelector, Integer argument) {
            if (childSelector == null) {
                throw new NullPointerException();
            }
            this.treeKind = treeKind;
            this.childSelector = childSelector;
            this.argument = argument;
        }

        public ASTEntry(Tree.Kind treeKind, String childSelector) {
            this(treeKind, childSelector, null);
        }

        public Tree.Kind getTreeKind() {
            return this.treeKind;
        }

        public String getChildSelector() {
            return this.childSelector;
        }

        public boolean childSelectorIs(String s) {
            return this.childSelector.equals(s);
        }

        public int getArgument() {
            if (this.argument >= (this.negativeAllowed() ? -1 : 0)) {
                return this.argument;
            }
            throw new IllegalStateException("Value not set.");
        }

        public boolean hasArgument() {
            return this.argument == null ? false : (this.argument >= 0 ? true : this.negativeAllowed());
        }

        private boolean negativeAllowed() {
            switch (this.treeKind) {
                case CLASS: {
                    return this.childSelectorIs(ASTPath.BOUND);
                }
                case METHOD: {
                    return this.childSelectorIs(ASTPath.PARAMETER);
                }
            }
            return false;
        }

        @Override
        public int compareTo(ASTEntry o) {
            if (o == null) {
                return 1;
            }
            int c = this.treeKind.compareTo(o.treeKind);
            if (c != 0) {
                return c;
            }
            c = this.childSelector.compareTo(o.childSelector);
            if (c != 0) {
                return c;
            }
            return o.argument == null ? (this.argument == null ? 0 : 1) : (this.argument == null ? -1 : this.argument.compareTo(o.argument));
        }

        public boolean equals(Object o) {
            return o instanceof ASTEntry && this.compareTo((ASTEntry)o) == 0;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.treeKind, this.childSelector, this.argument});
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.treeKind.asInterface().getSimpleName().replace("Tree", ""));
            b.append(".").append(this.childSelector);
            if (this.argument != null) {
                b.append(" ").append(this.argument);
            }
            return b.toString();
        }
    }

    static class Parser {
        StreamTokenizer st;

        Parser(String s) {
            this.st = new StreamTokenizer(new StringReader(s));
        }

        private void getTok() {
            try {
                this.st.nextToken();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean gotType(int t) {
            return this.st.ttype == t;
        }

        private int intVal() throws ParseException {
            int n;
            if (this.gotType(-2) && (double)(n = (int)this.st.nval) == this.st.nval) {
                return n;
            }
            throw new ParseException("expected integer, got " + this.st);
        }

        private String strVal() throws ParseException {
            if (this.gotType(-3)) {
                return this.st.sval;
            }
            throw new ParseException("expected string, got " + this.st);
        }

        ASTPath parseASTPath() throws ParseException {
            ASTPath astPath = new ASTPath().extend(this.parseASTEntry());
            while (this.gotType(44)) {
                this.getTok();
                astPath = astPath.extend(this.parseASTEntry());
            }
            return astPath;
        }

        ASTEntry parseASTEntry() throws ParseException {
            String s = this.strVal();
            if (s.equals("AnnotatedType")) {
                return this.newASTEntry(Tree.Kind.ANNOTATED_TYPE, new String[]{ASTPath.ANNOTATION, ASTPath.UNDERLYING_TYPE}, new String[]{ASTPath.ANNOTATION});
            }
            if (s.equals("ArrayAccess")) {
                return this.newASTEntry(Tree.Kind.ARRAY_ACCESS, new String[]{ASTPath.EXPRESSION, ASTPath.INDEX});
            }
            if (s.equals("ArrayType")) {
                return this.newASTEntry(Tree.Kind.ARRAY_TYPE, new String[]{ASTPath.TYPE});
            }
            if (s.equals("Assert")) {
                return this.newASTEntry(Tree.Kind.ASSERT, new String[]{ASTPath.CONDITION, ASTPath.DETAIL});
            }
            if (s.equals("Assignment")) {
                return this.newASTEntry(Tree.Kind.ASSIGNMENT, new String[]{ASTPath.VARIABLE, ASTPath.EXPRESSION});
            }
            if (s.equals("Binary")) {
                return this.newASTEntry(Tree.Kind.PLUS, new String[]{ASTPath.LEFT_OPERAND, ASTPath.RIGHT_OPERAND});
            }
            if (s.equals("Block")) {
                return this.newASTEntry(Tree.Kind.BLOCK, new String[]{ASTPath.STATEMENT}, new String[]{ASTPath.STATEMENT});
            }
            if (s.equals("Case")) {
                return this.newASTEntry(Tree.Kind.CASE, new String[]{ASTPath.EXPRESSION, ASTPath.STATEMENT}, new String[]{ASTPath.STATEMENT});
            }
            if (s.equals("Catch")) {
                return this.newASTEntry(Tree.Kind.CATCH, new String[]{ASTPath.PARAMETER, ASTPath.BLOCK});
            }
            if (s.equals("Class")) {
                return this.newASTEntry(Tree.Kind.CLASS, new String[]{ASTPath.BOUND, ASTPath.INITIALIZER, ASTPath.TYPE_PARAMETER}, new String[]{ASTPath.BOUND, ASTPath.INITIALIZER, ASTPath.TYPE_PARAMETER});
            }
            if (s.equals("CompoundAssignment")) {
                return this.newASTEntry(Tree.Kind.PLUS_ASSIGNMENT, new String[]{ASTPath.VARIABLE, ASTPath.EXPRESSION});
            }
            if (s.equals("ConditionalExpression")) {
                return this.newASTEntry(Tree.Kind.CONDITIONAL_EXPRESSION, new String[]{ASTPath.CONDITION, ASTPath.TRUE_EXPRESSION, ASTPath.FALSE_EXPRESSION});
            }
            if (s.equals("DoWhileLoop")) {
                return this.newASTEntry(Tree.Kind.DO_WHILE_LOOP, new String[]{ASTPath.CONDITION, ASTPath.STATEMENT});
            }
            if (s.equals("EnhancedForLoop")) {
                return this.newASTEntry(Tree.Kind.ENHANCED_FOR_LOOP, new String[]{ASTPath.VARIABLE, ASTPath.EXPRESSION, ASTPath.STATEMENT});
            }
            if (s.equals("ExpressionStatement")) {
                return this.newASTEntry(Tree.Kind.EXPRESSION_STATEMENT, new String[]{ASTPath.EXPRESSION});
            }
            if (s.equals("ForLoop")) {
                return this.newASTEntry(Tree.Kind.FOR_LOOP, new String[]{ASTPath.INITIALIZER, ASTPath.CONDITION, ASTPath.UPDATE, ASTPath.STATEMENT}, new String[]{ASTPath.INITIALIZER, ASTPath.UPDATE});
            }
            if (s.equals("If")) {
                return this.newASTEntry(Tree.Kind.IF, new String[]{ASTPath.CONDITION, ASTPath.THEN_STATEMENT, ASTPath.ELSE_STATEMENT});
            }
            if (s.equals("InstanceOf")) {
                return this.newASTEntry(Tree.Kind.INSTANCE_OF, new String[]{ASTPath.EXPRESSION, ASTPath.TYPE});
            }
            if (s.equals("LabeledStatement")) {
                return this.newASTEntry(Tree.Kind.LABELED_STATEMENT, new String[]{ASTPath.STATEMENT});
            }
            if (s.equals("LambdaExpression")) {
                return this.newASTEntry(Tree.Kind.LAMBDA_EXPRESSION, new String[]{ASTPath.PARAMETER, ASTPath.BODY}, new String[]{ASTPath.PARAMETER});
            }
            if (s.equals("MemberReference")) {
                return this.newASTEntry(Tree.Kind.MEMBER_REFERENCE, new String[]{ASTPath.QUALIFIER_EXPRESSION, ASTPath.TYPE_ARGUMENT}, new String[]{ASTPath.TYPE_ARGUMENT});
            }
            if (s.equals("MemberSelect")) {
                return this.newASTEntry(Tree.Kind.MEMBER_SELECT, new String[]{ASTPath.EXPRESSION});
            }
            if (s.equals("Method")) {
                return this.newASTEntry(Tree.Kind.METHOD, new String[]{ASTPath.BODY, ASTPath.PARAMETER, ASTPath.TYPE, ASTPath.TYPE_PARAMETER}, new String[]{ASTPath.PARAMETER, ASTPath.TYPE_PARAMETER});
            }
            if (s.equals("MethodInvocation")) {
                return this.newASTEntry(Tree.Kind.METHOD_INVOCATION, new String[]{ASTPath.TYPE_ARGUMENT, ASTPath.METHOD_SELECT, ASTPath.ARGUMENT}, new String[]{ASTPath.TYPE_ARGUMENT, ASTPath.ARGUMENT});
            }
            if (s.equals("NewArray")) {
                return this.newASTEntry(Tree.Kind.NEW_ARRAY, new String[]{ASTPath.TYPE, ASTPath.DIMENSION, ASTPath.INITIALIZER}, new String[]{ASTPath.TYPE, ASTPath.DIMENSION, ASTPath.INITIALIZER});
            }
            if (s.equals("NewClass")) {
                return this.newASTEntry(Tree.Kind.NEW_CLASS, new String[]{ASTPath.ENCLOSING_EXPRESSION, ASTPath.TYPE_ARGUMENT, ASTPath.IDENTIFIER, ASTPath.ARGUMENT, ASTPath.CLASS_BODY}, new String[]{ASTPath.TYPE_ARGUMENT, ASTPath.ARGUMENT});
            }
            if (s.equals("ParameterizedType")) {
                return this.newASTEntry(Tree.Kind.PARAMETERIZED_TYPE, new String[]{ASTPath.TYPE, ASTPath.TYPE_ARGUMENT}, new String[]{ASTPath.TYPE_ARGUMENT});
            }
            if (s.equals("Parenthesized")) {
                return this.newASTEntry(Tree.Kind.PARENTHESIZED, new String[]{ASTPath.EXPRESSION});
            }
            if (s.equals("Return")) {
                return this.newASTEntry(Tree.Kind.RETURN, new String[]{ASTPath.EXPRESSION});
            }
            if (s.equals("Switch")) {
                return this.newASTEntry(Tree.Kind.SWITCH, new String[]{ASTPath.EXPRESSION, ASTPath.CASE}, new String[]{ASTPath.CASE});
            }
            if (s.equals("Synchronized")) {
                return this.newASTEntry(Tree.Kind.SYNCHRONIZED, new String[]{ASTPath.EXPRESSION, ASTPath.BLOCK});
            }
            if (s.equals("Throw")) {
                return this.newASTEntry(Tree.Kind.THROW, new String[]{ASTPath.EXPRESSION});
            }
            if (s.equals("Try")) {
                return this.newASTEntry(Tree.Kind.TRY, new String[]{ASTPath.BLOCK, ASTPath.CATCH, ASTPath.FINALLY_BLOCK}, new String[]{ASTPath.CATCH});
            }
            if (s.equals("TypeCast")) {
                return this.newASTEntry(Tree.Kind.TYPE_CAST, new String[]{ASTPath.TYPE, ASTPath.EXPRESSION});
            }
            if (s.equals("Unary")) {
                return this.newASTEntry(Tree.Kind.UNARY_PLUS, new String[]{ASTPath.EXPRESSION});
            }
            if (s.equals("UnionType")) {
                return this.newASTEntry(Tree.Kind.UNION_TYPE, new String[]{ASTPath.TYPE_ALTERNATIVE}, new String[]{ASTPath.TYPE_ALTERNATIVE});
            }
            if (s.equals("Variable")) {
                return this.newASTEntry(Tree.Kind.VARIABLE, new String[]{ASTPath.TYPE, ASTPath.INITIALIZER});
            }
            if (s.equals("WhileLoop")) {
                return this.newASTEntry(Tree.Kind.WHILE_LOOP, new String[]{ASTPath.CONDITION, ASTPath.STATEMENT});
            }
            if (s.equals("Wildcard")) {
                return this.newASTEntry(Tree.Kind.UNBOUNDED_WILDCARD, new String[]{ASTPath.BOUND});
            }
            throw new ParseException("Invalid AST path type: " + s);
        }

        private ASTEntry newASTEntry(Tree.Kind kind, String[] legalChildSelectors) throws ParseException {
            return this.newASTEntry(kind, legalChildSelectors, null);
        }

        private ASTEntry newASTEntry(Tree.Kind kind, String[] legalChildSelectors, String[] argumentChildSelectors) throws ParseException {
            if (!this.gotType(46)) {
                throw new ParseException("expected '.', got " + this.st);
            }
            this.getTok();
            String s = this.strVal();
            for (String arg : legalChildSelectors) {
                if (!s.equals(arg)) continue;
                if (argumentChildSelectors != null && ArraysPlume.indexOf(argumentChildSelectors, (Object)arg) >= 0) {
                    this.getTok();
                    return new ASTEntry(kind, arg, this.intVal());
                }
                return new ASTEntry(kind, arg);
            }
            throw new ParseException("Invalid argument for " + (Object)((Object)kind) + " (legal arguments - " + Arrays.toString(legalChildSelectors) + "): " + s);
        }
    }

    static class Matcher {
        public static final DebugWriter dbug = new DebugWriter(false);
        private ASTPath astPath;

        Matcher(ASTPath astPath) {
            this.astPath = astPath;
        }

        private boolean nonDecl(TreePath path) {
            switch (path.getLeaf().getKind()) {
                case CLASS: 
                case METHOD: {
                    return false;
                }
                case VARIABLE: {
                    TreePath parentPath = path.getParentPath();
                    return parentPath != null && parentPath.getLeaf().getKind() != Tree.Kind.CLASS;
                }
            }
            return true;
        }

        public boolean matches(TreePath path) {
            return this.matches(path, -1);
        }

        public boolean matches(TreePath path, int depth) {
            if (path == null) {
                return false;
            }
            ArrayList<Tree> actualPath = new ArrayList<Tree>();
            while (path != null && this.nonDecl(path)) {
                actualPath.add(0, path.getLeaf());
                path = path.getParentPath();
            }
            if (dbug.isEnabled()) {
                dbug.debug("AST [%s]%n", this.astPath);
                for (Tree t : actualPath) {
                    dbug.debug("  %s: %s%n", new Object[]{t.getKind(), t.toString().replace('\n', ' ')});
                }
            }
            if (this.astPath.isEmpty() || actualPath.isEmpty() || actualPath.size() != this.astPath.size() + 1) {
                return false;
            }
            for (int i = 0; i < this.astPath.size() && i < actualPath.size(); ++i) {
                ASTEntry astNode = (ASTEntry)this.astPath.get(i);
                Tree actualNode = (Tree)actualPath.get(i);
                Tree next = null;
                dbug.debug("astNode: %s%n", astNode);
                dbug.debug("actualNode: %s%n", new Object[]{actualNode.getKind()});
                if (!Matcher.kindsMatch(astNode.getTreeKind(), actualNode.getKind())) {
                    return false;
                }
                switch (actualNode.getKind()) {
                    case ANNOTATED_TYPE: {
                        AnnotatedTypeTree annotatedType = (AnnotatedTypeTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.ANNOTATION)) {
                            List<? extends AnnotationTree> annos;
                            int arg = astNode.getArgument();
                            if (arg >= (annos = annotatedType.getAnnotations()).size()) {
                                return false;
                            }
                            next = annos.get(arg);
                            break;
                        }
                        next = annotatedType.getUnderlyingType();
                        break;
                    }
                    case ARRAY_ACCESS: {
                        ArrayAccessTree arrayAccess = (ArrayAccessTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.EXPRESSION)) {
                            next = arrayAccess.getExpression();
                            break;
                        }
                        next = arrayAccess.getIndex();
                        break;
                    }
                    case ARRAY_TYPE: {
                        ArrayTypeTree arrayType = (ArrayTypeTree)actualNode;
                        next = arrayType.getType();
                        break;
                    }
                    case ASSERT: {
                        AssertTree azzert = (AssertTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.CONDITION)) {
                            next = azzert.getCondition();
                            break;
                        }
                        next = azzert.getDetail();
                        break;
                    }
                    case ASSIGNMENT: {
                        AssignmentTree assignment = (AssignmentTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.VARIABLE)) {
                            next = assignment.getVariable();
                            break;
                        }
                        next = assignment.getExpression();
                        break;
                    }
                    case BLOCK: {
                        BlockTree block = (BlockTree)actualNode;
                        int arg = astNode.getArgument();
                        List<? extends StatementTree> statements = block.getStatements();
                        if (arg >= block.getStatements().size()) {
                            return false;
                        }
                        next = statements.get(arg);
                        break;
                    }
                    case CASE: {
                        CaseTree caze = (CaseTree)actualNode;
                        int arg = astNode.getArgument();
                        if (astNode.childSelectorIs(ASTPath.EXPRESSION)) {
                            List<? extends ExpressionTree> expressions = CaseUtils.caseTreeGetExpressions(caze);
                            if (!expressions.isEmpty() && arg >= expressions.size()) {
                                return false;
                            }
                            next = expressions.get(arg);
                            break;
                        }
                        List<? extends StatementTree> statements = caze.getStatements();
                        if (arg >= statements.size()) {
                            return false;
                        }
                        next = statements.get(arg);
                        break;
                    }
                    case CATCH: {
                        CatchTree cach = (CatchTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.PARAMETER)) {
                            next = cach.getParameter();
                            break;
                        }
                        next = cach.getBlock();
                        break;
                    }
                    case CLASS: {
                        ClassTree clazz = (ClassTree)actualNode;
                        int arg = astNode.getArgument();
                        if (astNode.childSelectorIs(ASTPath.BOUND)) {
                            next = arg == -1 ? clazz.getExtendsClause() : clazz.getImplementsClause().get(arg);
                            break;
                        }
                        next = clazz.getTypeParameters().get(arg);
                        break;
                    }
                    case CONDITIONAL_EXPRESSION: {
                        ConditionalExpressionTree conditionalExpression = (ConditionalExpressionTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.CONDITION)) {
                            next = conditionalExpression.getCondition();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.TRUE_EXPRESSION)) {
                            next = conditionalExpression.getTrueExpression();
                            break;
                        }
                        next = conditionalExpression.getFalseExpression();
                        break;
                    }
                    case DO_WHILE_LOOP: {
                        DoWhileLoopTree doWhileLoop = (DoWhileLoopTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.CONDITION)) {
                            next = doWhileLoop.getCondition();
                            break;
                        }
                        next = doWhileLoop.getStatement();
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        EnhancedForLoopTree enhancedForLoop = (EnhancedForLoopTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.VARIABLE)) {
                            next = enhancedForLoop.getVariable();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.EXPRESSION)) {
                            next = enhancedForLoop.getExpression();
                            break;
                        }
                        next = enhancedForLoop.getStatement();
                        break;
                    }
                    case EXPRESSION_STATEMENT: {
                        ExpressionStatementTree expressionStatement = (ExpressionStatementTree)actualNode;
                        next = expressionStatement.getExpression();
                        break;
                    }
                    case FOR_LOOP: {
                        List<Tree> inits;
                        ForLoopTree forLoop = (ForLoopTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.INITIALIZER)) {
                            int arg = astNode.getArgument();
                            if (arg >= (inits = forLoop.getInitializer()).size()) {
                                return false;
                            }
                            next = inits.get(arg);
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.CONDITION)) {
                            next = forLoop.getCondition();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.UPDATE)) {
                            List<? extends ExpressionStatementTree> updates;
                            int arg = astNode.getArgument();
                            if (arg >= (updates = forLoop.getUpdate()).size()) {
                                return false;
                            }
                            next = updates.get(arg);
                            break;
                        }
                        next = forLoop.getStatement();
                        break;
                    }
                    case IF: {
                        IfTree iff = (IfTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.CONDITION)) {
                            next = iff.getCondition();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.THEN_STATEMENT)) {
                            next = iff.getThenStatement();
                            break;
                        }
                        next = iff.getElseStatement();
                        break;
                    }
                    case INSTANCE_OF: {
                        InstanceOfTree instanceOf = (InstanceOfTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.EXPRESSION)) {
                            next = instanceOf.getExpression();
                            break;
                        }
                        next = instanceOf.getType();
                        break;
                    }
                    case LABELED_STATEMENT: {
                        LabeledStatementTree labeledStatement = (LabeledStatementTree)actualNode;
                        next = labeledStatement.getStatement();
                        break;
                    }
                    case LAMBDA_EXPRESSION: {
                        LambdaExpressionTree lambdaExpression = (LambdaExpressionTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.PARAMETER)) {
                            List<? extends VariableTree> params;
                            int arg = astNode.getArgument();
                            if (arg >= (params = lambdaExpression.getParameters()).size()) {
                                return false;
                            }
                            next = params.get(arg);
                            break;
                        }
                        next = lambdaExpression.getBody();
                        break;
                    }
                    case MEMBER_REFERENCE: {
                        List<Tree> typeArgs;
                        MemberReferenceTree memberReference = (MemberReferenceTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.QUALIFIER_EXPRESSION)) {
                            next = memberReference.getQualifierExpression();
                            break;
                        }
                        int arg = astNode.getArgument();
                        if (arg >= (typeArgs = memberReference.getTypeArguments()).size()) {
                            return false;
                        }
                        next = typeArgs.get(arg);
                        break;
                    }
                    case MEMBER_SELECT: {
                        MemberSelectTree memberSelect = (MemberSelectTree)actualNode;
                        next = memberSelect.getExpression();
                        break;
                    }
                    case METHOD: {
                        MethodTree method = (MethodTree)actualNode;
                        int arg = astNode.getArgument();
                        if (astNode.childSelectorIs(ASTPath.TYPE)) {
                            next = method.getReturnType();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.PARAMETER)) {
                            next = arg == -1 ? method.getReceiverParameter() : (Tree)method.getParameters().get(arg);
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.TYPE_PARAMETER)) {
                            next = method.getTypeParameters().get(arg);
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.BODY)) {
                            next = method.getBody();
                            break;
                        }
                        return false;
                    }
                    case METHOD_INVOCATION: {
                        List<? extends ExpressionTree> args;
                        List<Tree> typeArgs;
                        MethodInvocationTree methodInvocation = (MethodInvocationTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.TYPE_ARGUMENT)) {
                            int arg = astNode.getArgument();
                            if (arg >= (typeArgs = methodInvocation.getTypeArguments()).size()) {
                                return false;
                            }
                            next = typeArgs.get(arg);
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.METHOD_SELECT)) {
                            next = methodInvocation.getMethodSelect();
                            break;
                        }
                        int arg = astNode.getArgument();
                        if (arg >= (args = methodInvocation.getArguments()).size()) {
                            return false;
                        }
                        next = args.get(arg);
                        break;
                    }
                    case NEW_ARRAY: {
                        List<Tree> inits;
                        NewArrayTree newArray = (NewArrayTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.TYPE)) {
                            int arg = astNode.getArgument();
                            if (arg < 0) {
                                next = newArray.getType();
                                break;
                            }
                            return arg == depth;
                        }
                        if (astNode.childSelectorIs(ASTPath.DIMENSION)) {
                            List<? extends ExpressionTree> dims;
                            int arg = astNode.getArgument();
                            if (arg >= (dims = newArray.getDimensions()).size()) {
                                return false;
                            }
                            next = dims.get(arg);
                            break;
                        }
                        int arg = astNode.getArgument();
                        if (arg >= (inits = newArray.getInitializers()).size()) {
                            return false;
                        }
                        next = inits.get(arg);
                        break;
                    }
                    case NEW_CLASS: {
                        List<? extends ExpressionTree> args;
                        List<Tree> typeArgs;
                        NewClassTree newClass = (NewClassTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.ENCLOSING_EXPRESSION)) {
                            next = newClass.getEnclosingExpression();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.TYPE_ARGUMENT)) {
                            int arg = astNode.getArgument();
                            if (arg >= (typeArgs = newClass.getTypeArguments()).size()) {
                                return false;
                            }
                            next = typeArgs.get(arg);
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.IDENTIFIER)) {
                            next = newClass.getIdentifier();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.ARGUMENT)) {
                            int arg = astNode.getArgument();
                            if (arg >= (args = newClass.getArguments()).size()) {
                                return false;
                            }
                            next = args.get(arg);
                            break;
                        }
                        next = newClass.getClassBody();
                        break;
                    }
                    case PARAMETERIZED_TYPE: {
                        List<Tree> typeArgs;
                        ParameterizedTypeTree parameterizedType = (ParameterizedTypeTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.TYPE)) {
                            next = parameterizedType.getType();
                            break;
                        }
                        int arg = astNode.getArgument();
                        if (arg >= (typeArgs = parameterizedType.getTypeArguments()).size()) {
                            return false;
                        }
                        next = typeArgs.get(arg);
                        break;
                    }
                    case PARENTHESIZED: {
                        ParenthesizedTree parenthesized = (ParenthesizedTree)actualNode;
                        next = parenthesized.getExpression();
                        break;
                    }
                    case RETURN: {
                        ReturnTree returnn = (ReturnTree)actualNode;
                        next = returnn.getExpression();
                        break;
                    }
                    case SWITCH: {
                        List<? extends CaseTree> cases;
                        SwitchTree zwitch = (SwitchTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.EXPRESSION)) {
                            next = zwitch.getExpression();
                            break;
                        }
                        int arg = astNode.getArgument();
                        if (arg >= (cases = zwitch.getCases()).size()) {
                            return false;
                        }
                        next = cases.get(arg);
                        break;
                    }
                    case SYNCHRONIZED: {
                        SynchronizedTree synchronizzed = (SynchronizedTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.EXPRESSION)) {
                            next = synchronizzed.getExpression();
                            break;
                        }
                        next = synchronizzed.getBlock();
                        break;
                    }
                    case THROW: {
                        ThrowTree throww = (ThrowTree)actualNode;
                        next = throww.getExpression();
                        break;
                    }
                    case TRY: {
                        List<? extends Tree> resources;
                        TryTree tryy = (TryTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.BLOCK)) {
                            next = tryy.getBlock();
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.CATCH)) {
                            List<? extends CatchTree> catches;
                            int arg = astNode.getArgument();
                            if (arg >= (catches = tryy.getCatches()).size()) {
                                return false;
                            }
                            next = catches.get(arg);
                            break;
                        }
                        if (astNode.childSelectorIs(ASTPath.FINALLY_BLOCK)) {
                            next = tryy.getFinallyBlock();
                            break;
                        }
                        int arg = astNode.getArgument();
                        if (arg >= (resources = tryy.getResources()).size()) {
                            return false;
                        }
                        next = resources.get(arg);
                        break;
                    }
                    case TYPE_CAST: {
                        TypeCastTree typeCast = (TypeCastTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.TYPE)) {
                            next = typeCast.getType();
                            break;
                        }
                        next = typeCast.getExpression();
                        break;
                    }
                    case UNION_TYPE: {
                        UnionTypeTree unionType = (UnionTypeTree)actualNode;
                        int arg = astNode.getArgument();
                        List<? extends Tree> typeAlts = unionType.getTypeAlternatives();
                        if (arg >= typeAlts.size()) {
                            return false;
                        }
                        next = typeAlts.get(arg);
                        break;
                    }
                    case VARIABLE: {
                        VariableTree var = (VariableTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.INITIALIZER)) {
                            next = var.getInitializer();
                            break;
                        }
                        next = var.getType();
                        break;
                    }
                    case WHILE_LOOP: {
                        WhileLoopTree whileLoop = (WhileLoopTree)actualNode;
                        if (astNode.childSelectorIs(ASTPath.CONDITION)) {
                            next = whileLoop.getCondition();
                            break;
                        }
                        next = whileLoop.getStatement();
                        break;
                    }
                    default: {
                        if (ASTPath.isBinaryOperator(actualNode.getKind())) {
                            BinaryTree binary = (BinaryTree)actualNode;
                            if (astNode.childSelectorIs(ASTPath.LEFT_OPERAND)) {
                                next = binary.getLeftOperand();
                                break;
                            }
                            next = binary.getRightOperand();
                            break;
                        }
                        if (ASTPath.isCompoundAssignment(actualNode.getKind())) {
                            CompoundAssignmentTree compoundAssignment = (CompoundAssignmentTree)actualNode;
                            if (astNode.childSelectorIs(ASTPath.VARIABLE)) {
                                next = compoundAssignment.getVariable();
                                break;
                            }
                            next = compoundAssignment.getExpression();
                            break;
                        }
                        if (ASTPath.isUnaryOperator(actualNode.getKind())) {
                            UnaryTree unary = (UnaryTree)actualNode;
                            next = unary.getExpression();
                            break;
                        }
                        if (ASTPath.isWildcard(actualNode.getKind())) {
                            WildcardTree wildcard = (WildcardTree)actualNode;
                            if (i > 0) {
                                Tree ancestor = (Tree)actualPath.get(i - 1);
                                if (ancestor.getKind() == Tree.Kind.INSTANCE_OF) {
                                    System.err.println("WARNING: wildcard bounds not allowed in 'instanceof' expression; skipping insertion");
                                    return false;
                                }
                                if (i > 1 && ancestor.getKind() == Tree.Kind.PARAMETERIZED_TYPE && (ancestor = (Tree)actualPath.get(i - 2)).getKind() == Tree.Kind.ARRAY_TYPE) {
                                    System.err.println("WARNING: wildcard bounds not allowed in generic array type; skipping insertion");
                                    return false;
                                }
                            }
                            next = wildcard.getBound();
                            break;
                        }
                        throw new IllegalArgumentException("Illegal kind: " + (Object)((Object)actualNode.getKind()));
                    }
                }
                if (dbug.isEnabled()) {
                    String nextString = next.toString();
                    if (nextString.length() > 80) {
                        nextString = nextString.substring(0, 80) + "...";
                    }
                    dbug.debug("next: %s%n", nextString);
                }
                if (next == actualPath.get(i + 1)) continue;
                dbug.debug("no next match%n", new Object[0]);
                return false;
            }
            return true;
        }

        private static boolean kindsMatch(Tree.Kind kind1, Tree.Kind kind2) {
            return kind1 == kind2 || ASTPath.isCompoundAssignment(kind1) && ASTPath.isCompoundAssignment(kind2) || ASTPath.isUnaryOperator(kind1) && ASTPath.isUnaryOperator(kind2) || ASTPath.isBinaryOperator(kind1) && ASTPath.isBinaryOperator(kind2) || ASTPath.isWildcard(kind1) && ASTPath.isWildcard(kind2);
        }
    }
}

