/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.ABlock;
import org.checkerframework.afu.scenelib.el.AClass;
import org.checkerframework.afu.scenelib.el.ADeclaration;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AExpression;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.ATypeElementWithType;
import org.checkerframework.afu.scenelib.el.AnnotationDef;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.io.IndexFileParser;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;

public class AScene
implements Cloneable {
    private static boolean checkClones = true;
    public final VivifyingMap<String, AElement> packages = AElement.newVivifyingLHMap_AE();
    public final Map<String, Set<String>> imports = new LinkedHashMap<String, Set<String>>();
    public final VivifyingMap<String, AClass> classes = new VivifyingMap<String, AClass>(new LinkedHashMap()){

        @Override
        public AClass createValueFor(String k) {
            return new AClass(k);
        }

        @Override
        public boolean isEmptyValue(AClass v) {
            return v.isEmpty();
        }
    };
    private static ElementVisitor<Void, AElement> checkVisitor = new ElementVisitor<Void, AElement>(){

        @Override
        public Void visitAnnotationDef(AnnotationDef el, AElement arg) {
            return null;
        }

        @Override
        public Void visitBlock(ABlock el, AElement arg) {
            ABlock b = (ABlock)arg;
            AScene.checkCloneElems(el.locals, b.locals);
            return null;
        }

        @Override
        public Void visitClass(AClass el, AElement arg) {
            AClass c = (AClass)arg;
            AScene.checkCloneElems(el.bounds, c.bounds);
            AScene.checkCloneElems(el.extendsImplements, c.extendsImplements);
            AScene.checkCloneElems(el.fieldInits, c.fieldInits);
            AScene.checkCloneElems(el.fields, c.fields);
            AScene.checkCloneElems(el.instanceInits, c.instanceInits);
            AScene.checkCloneElems(el.methods, c.methods);
            AScene.checkCloneElems(el.staticInits, c.staticInits);
            return this.visitDeclaration((ADeclaration)el, arg);
        }

        @Override
        public Void visitDeclaration(ADeclaration el, AElement arg) {
            ADeclaration d = (ADeclaration)arg;
            AScene.checkCloneElems(el.insertAnnotations, d.insertAnnotations);
            AScene.checkCloneElems(el.insertTypecasts, d.insertTypecasts);
            return this.visitElement((AElement)el, arg);
        }

        @Override
        public Void visitExpression(AExpression el, AElement arg) {
            AExpression e = (AExpression)arg;
            AScene.checkCloneObject(el.id, e.id);
            AScene.checkCloneElems(el.calls, e.calls);
            AScene.checkCloneElems(el.funs, e.funs);
            AScene.checkCloneElems(el.instanceofs, e.instanceofs);
            AScene.checkCloneElems(el.news, e.news);
            AScene.checkCloneElems(el.refs, e.refs);
            AScene.checkCloneElems(el.typecasts, e.typecasts);
            return this.visitElement((AElement)el, arg);
        }

        @Override
        public Void visitField(AField el, AElement arg) {
            AField f = (AField)arg;
            AScene.checkCloneElem(el.init, f.init);
            return this.visitDeclaration((ADeclaration)el, arg);
        }

        @Override
        public Void visitMethod(AMethod el, AElement arg) {
            AMethod m = (AMethod)arg;
            AScene.checkCloneObject(el.methodSignature, m.methodSignature);
            AScene.checkCloneElems(el.bounds, m.bounds);
            AScene.checkCloneElem(el.returnType, m.returnType);
            AScene.checkCloneElem(el.receiver, m.receiver);
            AScene.checkCloneElems(el.parameters, m.parameters);
            AScene.checkCloneElems(el.throwsException, m.throwsException);
            AScene.checkCloneElems(el.preconditions, m.preconditions);
            AScene.checkCloneElems(el.postconditions, m.postconditions);
            AScene.checkCloneElem(el.body, m.body);
            return null;
        }

        @Override
        public Void visitTypeElement(ATypeElement el, AElement arg) {
            ATypeElement t = (ATypeElement)arg;
            AScene.checkCloneObject(el.description, t.description);
            AScene.checkCloneElems(el.innerTypes, t.innerTypes);
            return null;
        }

        @Override
        public Void visitTypeElementWithType(ATypeElementWithType el, AElement arg) {
            ATypeElementWithType t = (ATypeElementWithType)arg;
            AScene.checkCloneObject(el.getType(), t.getType());
            return this.visitTypeElement((ATypeElement)el, arg);
        }

        @Override
        public Void visitElement(AElement el, AElement arg) {
            AScene.checkCloneObject(el.description, arg.description);
            if (el.tlAnnotationsHere.size() != arg.tlAnnotationsHere.size()) {
                AScene.cloneCheckFail();
            }
            for (Annotation a : el.tlAnnotationsHere) {
                if (arg.tlAnnotationsHere.contains(a)) continue;
                AScene.cloneCheckFail();
            }
            AScene.checkCloneElem(el.type, arg.type);
            return null;
        }
    };

    public AScene() {
    }

    public AScene(AScene scene) {
        for (String key : scene.packages.keySet()) {
            AElement val = (AElement)scene.packages.get(key);
            this.packages.put(key, val.clone());
        }
        for (String key : scene.imports.keySet()) {
            Set<String> value = scene.imports.get(key);
            LinkedHashSet<String> copy = new LinkedHashSet<String>();
            copy.addAll(value);
            this.imports.put(key, copy);
        }
        for (String key : scene.classes.keySet()) {
            AClass clazz = (AClass)scene.classes.get(key);
            this.classes.put(key, clazz.clone());
        }
        if (checkClones) {
            AScene.checkClone(this, scene);
        }
    }

    public AScene clone() {
        return new AScene(this);
    }

    public boolean equals(Object o) {
        return o instanceof AScene && ((AScene)o).equals(this);
    }

    public boolean equals(AScene o) {
        return o.classes.equals(this.classes) && o.packages.equals(this.packages);
    }

    public int hashCode() {
        return this.classes.hashCode() + this.packages.hashCode();
    }

    public Map<String, AClass> getClasses() {
        return ImmutableMap.copyOf(this.classes);
    }

    public boolean isEmpty() {
        return this.classes.isEmpty() && this.packages.isEmpty();
    }

    public void prune() {
        this.classes.prune();
        this.packages.prune();
    }

    public String unparse() {
        StringBuilder sb = new StringBuilder();
        sb.append("packages:\n");
        for (Map.Entry entry : this.packages.entrySet()) {
            sb.append("  " + (String)entry.getKey() + " => " + entry.getValue() + "\n");
        }
        sb.append("classes:\n");
        for (Map.Entry entry : this.classes.entrySet()) {
            sb.append("  " + (String)entry.getKey() + " => \n");
            sb.append(((AClass)entry.getValue()).unparse("    "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.unparse();
    }

    public static void checkClone(AScene s0, AScene s1) {
        if (s0 == null) {
            if (s1 != null) {
                AScene.cloneCheckFail();
            }
        } else {
            if (s1 == null) {
                AScene.cloneCheckFail();
            }
            s0.prune();
            s1.prune();
            if (s0 == s1) {
                AScene.cloneCheckFail();
            }
            AScene.checkCloneElems(s0.packages, s1.packages);
            AScene.checkCloneElems(s0.classes, s1.classes);
        }
    }

    public static <K, V extends AElement> void checkCloneElems(VivifyingMap<K, V> m0, VivifyingMap<K, V> m1) {
        if (m0 == null) {
            if (m1 != null) {
                AScene.cloneCheckFail();
            }
        } else if (m1 == null) {
            AScene.cloneCheckFail();
        } else {
            for (Object k : m0.keySet()) {
                AScene.checkCloneElem((AElement)m0.get(k), (AElement)m1.get(k));
            }
        }
    }

    public static void checkCloneElem(AElement e0, AElement e1) {
        AScene.checkCloneObject(e0, e1);
        if (e0 != null) {
            if (e0 == e1) {
                AScene.cloneCheckFail();
            }
            e0.accept(checkVisitor, e1);
        }
    }

    public static void checkCloneObject(Object o0, Object o1) {
        if (o0 == null ? o1 != null : !o0.equals(o1) || !o1.equals(o0)) {
            throw new RuntimeException(String.format("clone check failed for %s [%s] %s [%s]", o0, o0.getClass(), o1, o1.getClass()));
        }
    }

    private static void cloneCheckFail() {
        throw new RuntimeException("clone check failed");
    }

    public static void main(String[] args) {
        int status = 0;
        checkClones = true;
        for (int i = 0; i < args.length; ++i) {
            AScene s0 = new AScene();
            System.out.print(args[i] + ": ");
            try {
                IndexFileParser.parseFile(args[i], s0);
                AScene ignore = s0.clone();
                System.out.println("ok");
                continue;
            }
            catch (Throwable e) {
                status = 1;
                System.out.println("failed");
                e.printStackTrace();
            }
        }
        System.exit(status);
    }
}

