/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.ABlock;
import org.checkerframework.afu.scenelib.el.ADeclaration;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.BoundLocation;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.el.TypeIndexLocation;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;

public class AMethod
extends ADeclaration {
    public final String methodSignature;
    private List<? extends TypeParameterElement> typeParameters = null;
    public final VivifyingMap<BoundLocation, ATypeElement> bounds = ATypeElement.newVivifyingLHMap_ATE();
    private TypeMirror returnTypeMirror;
    public final ATypeElement returnType;
    public final AField receiver;
    public final VivifyingMap<Integer, AField> parameters = AField.newVivifyingLHMap_AF();
    public final VivifyingMap<TypeIndexLocation, ATypeElement> throwsException = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<String, AField> preconditions = AField.newVivifyingLHMap_AF();
    public final VivifyingMap<String, AField> postconditions = AField.newVivifyingLHMap_AF();
    public List<Annotation> contracts = Collections.emptyList();
    public ABlock body;

    AMethod(String methodSignature) {
        super("method: " + methodSignature);
        this.methodSignature = methodSignature;
        this.returnType = new ATypeElement("return type of " + methodSignature);
        this.receiver = new AField("receiver parameter type of " + methodSignature);
        this.body = new ABlock(methodSignature);
    }

    AMethod(AMethod other) {
        super((Object)("method: " + other.methodSignature), other);
        this.methodSignature = other.methodSignature;
        this.typeParameters = other.typeParameters == null ? null : new ArrayList<TypeParameterElement>(other.typeParameters);
        AMethod.copyMapContents(other.bounds, this.bounds);
        this.returnTypeMirror = other.returnTypeMirror == null ? null : other.returnTypeMirror;
        this.returnType = other.returnType.clone();
        this.receiver = other.receiver.clone();
        AMethod.copyMapContents(other.parameters, this.parameters);
        AMethod.copyMapContents(other.throwsException, this.throwsException);
        AMethod.copyMapContents(other.preconditions, this.preconditions);
        AMethod.copyMapContents(other.postconditions, this.postconditions);
        this.body = other.body.clone();
    }

    public void setFieldsFromMethodElement(ExecutableElement methodElt) {
        this.setReturnTypeMirror(methodElt.getReturnType());
        this.setTypeParameters(methodElt.getTypeParameters());
        this.vivifyAndAddTypeMirrorToParameters(methodElt);
    }

    public String getMethodName() {
        return this.methodSignature.substring(0, this.methodSignature.indexOf("("));
    }

    public List<? extends TypeParameterElement> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<? extends TypeParameterElement> typeParameters) {
        if (typeParameters == null) {
            return;
        }
        if (this.typeParameters != null && !this.typeParameters.equals(typeParameters)) {
            throw new Error(String.format("setTypeParameters(%s): already is %s%n", typeParameters, this.typeParameters));
        }
        this.typeParameters = typeParameters;
    }

    private void vivifyAndAddTypeMirrorToParameters(ExecutableElement methodElt) {
        for (int i = 0; i < methodElt.getParameters().size(); ++i) {
            VariableElement ve = methodElt.getParameters().get(i);
            TypeMirror type = ve.asType();
            Name name = ve.getSimpleName();
            this.vivifyAndAddTypeMirrorToParameter(i, type, name);
        }
    }

    public AField vivifyAndAddTypeMirrorToParameter(int i, TypeMirror type, Name simpleName) {
        AField param = this.parameters.getVivify(i);
        param.setName(simpleName.toString());
        if (param.getTypeMirror() == null) {
            param.setTypeMirror(type);
        }
        return param;
    }

    public AField vivifyAndAddTypeMirrorToPrecondition(String expression, TypeMirror type) {
        AField result = this.preconditions.getVivify(expression);
        result.setName(expression);
        if (result.getTypeMirror() == null) {
            result.setTypeMirror(type);
        }
        return result;
    }

    public AField vivifyAndAddTypeMirrorToPostcondition(String expression, TypeMirror type) {
        AField result = this.postconditions.getVivify(expression);
        result.setName(expression);
        if (result.getTypeMirror() == null) {
            result.setTypeMirror(type);
        }
        return result;
    }

    public TypeMirror getReturnTypeMirror() {
        return this.returnTypeMirror;
    }

    public void setReturnTypeMirror(TypeMirror returnTypeMirror) {
        if (returnTypeMirror == null) {
            return;
        }
        if (this.returnTypeMirror != null && this.returnTypeMirror != returnTypeMirror) {
            throw new Error(String.format("setReturnTypeMirror(%s): already is %s%n", returnTypeMirror, this.returnTypeMirror));
        }
        this.returnTypeMirror = returnTypeMirror;
    }

    public Map<Integer, AField> getParameters() {
        return ImmutableMap.copyOf(this.parameters);
    }

    public Map<String, AField> getPreconditions() {
        return ImmutableMap.copyOf(this.preconditions);
    }

    public Map<String, AField> getPostconditions() {
        return ImmutableMap.copyOf(this.postconditions);
    }

    @Override
    public AMethod clone() {
        return new AMethod(this);
    }

    @Override
    public boolean equals(AElement o) {
        return o instanceof AMethod && ((AMethod)o).equalsMethod(this);
    }

    boolean equalsMethod(AMethod o) {
        this.parameters.prune();
        o.parameters.prune();
        return super.equals(o) && this.methodSignature.equals(o.methodSignature) && this.bounds.equals(o.bounds) && this.returnType.equalsTypeElement(o.returnType) && this.receiver.equals(o.receiver) && this.parameters.equals(o.parameters) && this.throwsException.equals(o.throwsException) && this.preconditions.equals(o.preconditions) && this.postconditions.equals(o.postconditions) && this.body.equals(o.body);
    }

    @Override
    public int hashCode() {
        this.parameters.prune();
        return Objects.hash(super.hashCode(), this.methodSignature, this.bounds, this.returnType, this.receiver, this.parameters, this.throwsException, this.preconditions, this.postconditions, this.body);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.bounds.isEmpty() && this.returnType.isEmpty() && this.receiver.isEmpty() && this.parameters.isEmpty() && this.throwsException.isEmpty() && this.preconditions.isEmpty() && this.postconditions.isEmpty() && this.body.isEmpty();
    }

    @Override
    public void prune() {
        super.prune();
        this.bounds.prune();
        this.returnType.prune();
        this.receiver.prune();
        this.parameters.prune();
        this.throwsException.prune();
        this.preconditions.prune();
        this.postconditions.prune();
        this.body.prune();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AMethod ");
        sb.append(this.methodSignature);
        sb.append(": (");
        sb.append(" -1:");
        sb.append(this.receiver.toString());
        for (Map.Entry em : this.parameters.entrySet()) {
            Integer i = (Integer)em.getKey();
            sb.append(" ");
            sb.append(i);
            sb.append(":");
            AElement ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(" ");
            ATypeElement ate = ae.type;
            sb.append(ate.toString());
        }
        sb.append(" ");
        sb.append("ret:");
        sb.append(this.returnType.toString());
        sb.append(") ");
        sb.append(this.body.toString());
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitMethod(this, t);
    }
}

