/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;

public class AExpression
extends AElement {
    public final VivifyingMap<RelativeLocation, ATypeElement> typecasts = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> instanceofs = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> news = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> calls = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> refs = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, AMethod> funs = new VivifyingMap<RelativeLocation, AMethod>(new LinkedHashMap()){

        @Override
        public AMethod createValueFor(RelativeLocation k) {
            return new AMethod("" + k);
        }

        @Override
        public boolean isEmptyValue(AMethod v) {
            return v.isEmpty();
        }
    };
    protected Object id;

    AExpression(Object id) {
        super(id);
        this.id = id;
    }

    AExpression(AExpression expr) {
        super(expr);
        AExpression.copyMapContents(expr.typecasts, this.typecasts);
        AExpression.copyMapContents(expr.instanceofs, this.instanceofs);
        AExpression.copyMapContents(expr.news, this.news);
        AExpression.copyMapContents(expr.calls, this.calls);
        AExpression.copyMapContents(expr.refs, this.refs);
        AExpression.copyMapContents(expr.funs, this.funs);
        this.id = expr.id;
    }

    @Override
    public AExpression clone() {
        return new AExpression(this);
    }

    @Override
    public boolean equals(AElement o) {
        return o instanceof AExpression && ((AExpression)o).equalsExpression(this);
    }

    protected boolean equalsExpression(AExpression o) {
        return super.equals(o) && this.typecasts.equals(o.typecasts) && this.instanceofs.equals(o.instanceofs) && this.news.equals(o.news) && this.refs.equals(o.refs) && this.calls.equals(o.calls) && this.funs.equals(o.funs);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.typecasts.hashCode() + this.instanceofs.hashCode() + this.news.hashCode() + this.refs.hashCode() + this.calls.hashCode() + this.funs.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.typecasts.isEmpty() && this.instanceofs.isEmpty() && this.news.isEmpty() && this.refs.isEmpty() && this.calls.isEmpty() && this.funs.isEmpty();
    }

    @Override
    public void prune() {
        super.prune();
        this.typecasts.prune();
        this.instanceofs.prune();
        this.news.prune();
        this.refs.prune();
        this.calls.prune();
        this.funs.prune();
    }

    @Override
    public String toString() {
        boolean isOffset;
        AElement ae;
        RelativeLocation loc;
        StringBuilder sb = new StringBuilder();
        TreeMap<RelativeLocation, ATypeElement> map = new TreeMap<RelativeLocation, ATypeElement>();
        RelativeLocation prev = null;
        for (Map.Entry em : this.typecasts.entrySet()) {
            sb.append("typecast: ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        for (Map.Entry em : this.instanceofs.entrySet()) {
            sb.append("instanceof: ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        for (Map.Entry em : this.news.entrySet()) {
            sb.append("new ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        map.putAll(this.refs);
        for (Map.Entry em : map.entrySet()) {
            loc = (RelativeLocation)em.getKey();
            ae = (AElement)em.getValue();
            boolean bl = isOffset = loc.index < 0;
            if (prev == null || (isOffset ? loc.offset == prev.offset : loc.index == prev.index)) {
                sb.append("reference ");
                sb.append(isOffset ? "*" + loc.offset : "#" + loc.index);
                sb.append(": ");
                sb.append(ae.toString());
            }
            if (loc.type_index >= 0) {
                sb.append("typearg " + loc);
                sb.append(": ");
                sb.append(ae.toString());
                sb.append(' ');
            }
            prev = loc;
        }
        prev = null;
        map.clear();
        map.putAll(this.calls);
        for (Map.Entry em : map.entrySet()) {
            loc = (RelativeLocation)em.getKey();
            ae = (AElement)em.getValue();
            boolean bl = isOffset = loc.index < 0;
            if (prev == null || (isOffset ? loc.offset == prev.offset : loc.index == prev.index)) {
                sb.append("call ");
                sb.append(isOffset ? "*" + loc.offset : "#" + loc.index);
                sb.append(": ");
            }
            if (loc.type_index >= 0) {
                sb.append("typearg " + loc);
                sb.append(": ");
                sb.append(ae.toString());
                sb.append(' ');
            }
            prev = loc;
        }
        prev = null;
        map.clear();
        for (Map.Entry em : this.funs.entrySet()) {
            sb.append("lambda ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitExpression(this, t);
    }
}

