/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.ABlock;
import org.checkerframework.afu.scenelib.el.ADeclaration;
import org.checkerframework.afu.scenelib.el.AExpression;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.BoundLocation;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.el.TypeIndexLocation;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;
import org.plumelib.util.CollectionsPlume;

public class AClass
extends ADeclaration {
    public final VivifyingMap<BoundLocation, ATypeElement> bounds = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<TypeIndexLocation, ATypeElement> extendsImplements = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<String, AMethod> methods = AClass.createMethodMap();
    public final VivifyingMap<Integer, ABlock> staticInits = AClass.createInitBlockMap();
    public final VivifyingMap<Integer, ABlock> instanceInits = AClass.createInitBlockMap();
    public final VivifyingMap<String, AField> fields = AField.newVivifyingLHMap_AF();
    public final VivifyingMap<String, AExpression> fieldInits = AClass.createFieldInitMap();
    private TypeElement typeElement = null;
    public final String className;
    private final HashSet<String> enums = new HashSet();
    private List<VariableElement> enumConstants = null;
    private final HashSet<String> annotationTypes = new HashSet();
    private final HashSet<String> interfaces = new HashSet();
    private final HashSet<String> records = new HashSet();

    AClass(String className) {
        super("class: " + className);
        this.className = className;
    }

    AClass(AClass clazz) {
        super(clazz);
        this.className = clazz.className;
        AClass.copyMapContents(clazz.bounds, this.bounds);
        AClass.copyMapContents(clazz.extendsImplements, this.extendsImplements);
        AClass.copyMapContents(clazz.fieldInits, this.fieldInits);
        AClass.copyMapContents(clazz.fields, this.fields);
        AClass.copyMapContents(clazz.instanceInits, this.instanceInits);
        AClass.copyMapContents(clazz.methods, this.methods);
        AClass.copyMapContents(clazz.staticInits, this.staticInits);
    }

    @Override
    public AClass clone() {
        return new AClass(this);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AClass && ((AClass)o).equalsClass(this);
    }

    final boolean equalsClass(AClass o) {
        return super.equals(o) && this.className.equals(o.className) && this.bounds.equals(o.bounds) && this.methods.equals(o.methods) && this.fields.equals(o.fields) && this.extendsImplements.equals(o.extendsImplements);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.bounds.hashCode() + this.methods.hashCode() + this.fields.hashCode() + this.staticInits.hashCode() + this.instanceInits.hashCode() + this.extendsImplements.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.bounds.isEmpty() && this.methods.isEmpty() && this.fields.isEmpty() && this.staticInits.isEmpty() && this.instanceInits.isEmpty() && this.extendsImplements.isEmpty();
    }

    @Override
    public void prune() {
        super.prune();
        this.bounds.prune();
        this.methods.prune();
        this.fields.prune();
        this.staticInits.prune();
        this.instanceInits.prune();
        this.extendsImplements.prune();
    }

    @Override
    public String toString() {
        return "AClass: " + this.className;
    }

    public String unparse() {
        return this.unparse("");
    }

    public String unparse(String linePrefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(linePrefix);
        sb.append(this.toString());
        sb.append(System.lineSeparator());
        sb.append(linePrefix);
        sb.append("Annotations:" + System.lineSeparator());
        for (Annotation a : this.tlAnnotationsHere) {
            sb.append(linePrefix);
            sb.append("  " + a + System.lineSeparator());
        }
        sb.append(linePrefix);
        sb.append("Bounds:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.bounds, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Extends/implements:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.extendsImplements, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Fields:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.fields, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Field Initializers:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.fieldInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Static Initializers:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.staticInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Instance Initializers:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.instanceInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("AST Typecasts:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.insertTypecasts, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("AST Annotations:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.insertAnnotations, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Methods:" + System.lineSeparator());
        CollectionsPlume.mapToString(sb, this.methods, linePrefix + "  ");
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitClass(this, t);
    }

    private static VivifyingMap<String, AMethod> createMethodMap() {
        return new VivifyingMap<String, AMethod>(new LinkedHashMap()){

            @Override
            public AMethod createValueFor(String k) {
                return new AMethod(k);
            }

            @Override
            public boolean isEmptyValue(AMethod v) {
                return v.isEmpty();
            }
        };
    }

    private static VivifyingMap<Integer, ABlock> createInitBlockMap() {
        return new VivifyingMap<Integer, ABlock>(new LinkedHashMap()){

            @Override
            public ABlock createValueFor(Integer k) {
                return new ABlock(k);
            }

            @Override
            public boolean isEmptyValue(ABlock v) {
                return v.isEmpty();
            }
        };
    }

    private static VivifyingMap<String, AExpression> createFieldInitMap() {
        return new VivifyingMap<String, AExpression>(new LinkedHashMap()){

            @Override
            public AExpression createValueFor(String k) {
                return new AExpression(k);
            }

            @Override
            public boolean isEmptyValue(AExpression v) {
                return v.isEmpty();
            }
        };
    }

    public boolean isEnum(String className) {
        return this.enums.contains(className);
    }

    public boolean isEnum() {
        return this.enums.contains(this.className);
    }

    public void markAsEnum(String className) {
        this.enums.add(className);
    }

    public List<VariableElement> getEnumConstants() {
        if (this.enumConstants == null) {
            return null;
        }
        return ImmutableList.copyOf(this.enumConstants);
    }

    public void setEnumConstants(List<VariableElement> enumConstants) {
        if (this.enumConstants != null) {
            throw new Error(String.format("setEnumConstants was called multiple times with arguments %s and %s", this.enumConstants, enumConstants));
        }
        this.enumConstants = new ArrayList<VariableElement>(enumConstants);
    }

    public boolean isAnnotation(String className) {
        return this.annotationTypes.contains(className);
    }

    public boolean isAnnotation() {
        return this.annotationTypes.contains(this.className);
    }

    public void markAsAnnotation(String className) {
        this.annotationTypes.add(className);
    }

    public boolean isInterface(String className) {
        return this.interfaces.contains(className);
    }

    public boolean isInterface() {
        return this.interfaces.contains(this.className);
    }

    public void markAsInterface(String className) {
        this.interfaces.add(className);
    }

    public boolean isRecord(String className) {
        return this.records.contains(className);
    }

    public boolean isRecord() {
        return this.records.contains(this.className);
    }

    public void markAsRecord(String className) {
        this.records.add(className);
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public void setTypeElement(TypeElement typeElement) {
        if (this.typeElement == null) {
            this.typeElement = typeElement;
        } else if (!this.typeElement.equals(typeElement)) {
            throw new Error(String.format("setTypeElement(%s): type is already %s", typeElement, this.typeElement));
        }
    }

    public Map<String, AMethod> getMethods() {
        return ImmutableMap.copyOf(this.methods);
    }

    public Map<String, AField> getFields() {
        return ImmutableMap.copyOf(this.fields);
    }

    public Collection<? extends Annotation> getAnnotations() {
        return this.tlAnnotationsHere;
    }
}

