/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.Main;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;
import org.checkerframework.checker.signature.qual.ClassGetName;

public class ReturnTypeCriterion
implements Criterion {
    private final String methodName;
    private final Criterion inClassCriterion;
    private final Criterion sigMethodCriterion;

    public ReturnTypeCriterion(@ClassGetName String className, String methodName) {
        this.methodName = methodName;
        this.inClassCriterion = Criteria.inClass(className, false);
        this.sigMethodCriterion = methodName.isEmpty() ? null : Criteria.isSigMethod(methodName);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy(%s); this=%s%n", Main.leafString(path), this.toString());
        block0: do {
            if (path.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            if (this.sigMethodCriterion != null && !this.sigMethodCriterion.isSatisfiedBy(path)) break;
            for (path = path.getParentPath(); path != null && path.getLeaf() != null; path = path.getParentPath()) {
                if (!TreePathUtil.hasClassKind(path.getLeaf())) continue;
                if (!this.inClassCriterion.isSatisfiedBy(path)) break block0;
                Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy => true%n", new Object[0]);
                return true;
            }
            break;
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy => false%n", new Object[0]);
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.RETURN_TYPE;
    }

    public String toString() {
        return "ReturnTypeCriterion for method: " + this.methodName;
    }
}

