/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;

public class ReceiverCriterion
implements Criterion {
    private final String methodName;
    private final Criterion isSigMethodCriterion;

    public ReceiverCriterion(String methodName) {
        this.methodName = methodName;
        this.isSigMethodCriterion = Criteria.isSigMethod(methodName);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        MethodTree method;
        TreePath parent;
        if (path == null) {
            return false;
        }
        if (path.getLeaf().getKind() == Tree.Kind.METHOD) {
            if (this.isSigMethodCriterion.isSatisfiedBy(path)) {
                MethodTree leaf = (MethodTree)path.getLeaf();
                return leaf.getReceiverParameter() == null;
            }
            return false;
        }
        Tree param = null;
        for (parent = path; parent != null && parent.getLeaf().getKind() != Tree.Kind.METHOD; parent = parent.getParentPath()) {
            if (parent.getLeaf().getKind() != Tree.Kind.VARIABLE) continue;
            if (param == null) {
                param = parent.getLeaf();
                continue;
            }
            return false;
        }
        if (parent != null && param != null && param == (method = (MethodTree)parent.getLeaf()).getReceiverParameter()) {
            return this.isSigMethodCriterion.isSatisfiedBy(parent);
        }
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.RECEIVER;
    }

    public String toString() {
        return "ReceiverCriterion for method: " + this.methodName;
    }
}

