/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.Main;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;

final class PackageCriterion
implements Criterion {
    private final String name;

    PackageCriterion(String name) {
        this.name = name;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.PACKAGE;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree tree) {
        assert (path == null || path.getLeaf() == tree);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        CompilationUnitTree cu;
        Tree tree = path.getLeaf();
        Criteria.dbug.debug("PackageCriterion.isSatisfiedBy(%s, %s); this=%s%n", Main.leafString(path), tree, this.toString());
        if (tree.getKind() == Tree.Kind.COMPILATION_UNIT && (cu = (CompilationUnitTree)tree).getSourceFile().getName().endsWith("package-info.java")) {
            ExpressionTree pn = cu.getPackageName();
            assert (pn instanceof IdentifierTree || pn instanceof MemberSelectTree);
            if (this.name.equals(pn.toString())) {
                return true;
            }
        }
        Criteria.dbug.debug("PackageCriterion.isSatisfiedBy => false%n", new Object[0]);
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    public String toString() {
        return "package '" + this.name + "'";
    }
}

