/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.NewScanner;
import org.checkerframework.afu.scenelib.el.RelativeLocation;

public class NewCriterion
implements Criterion {
    private final String methodName;
    private final Criterion inMethodCriterion;
    private final RelativeLocation loc;

    public NewCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName.substring(0, methodName.lastIndexOf(")") + 1);
        this.inMethodCriterion = !methodName.startsWith("init for field") && !methodName.startsWith("static init number") && !methodName.startsWith("instance init number") ? Criteria.inMethod(methodName) : null;
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        if (this.inMethodCriterion != null && !this.inMethodCriterion.isSatisfiedBy(path)) {
            return this.isSatisfiedBy(path.getParentPath());
        }
        if (leaf.getKind() == Tree.Kind.NEW_CLASS || leaf.getKind() == Tree.Kind.NEW_ARRAY) {
            int indexInClass;
            int indexInSource = NewScanner.indexOfNewTree(path, leaf);
            boolean b = this.loc.isBytecodeOffset() ? indexInSource == (indexInClass = NewScanner.getMethodNewIndex(this.methodName, this.loc.offset).intValue()) : indexInSource == this.loc.index;
            return b;
        }
        return this.isSatisfiedBy(path.getParentPath());
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.NEW;
    }

    public String toString() {
        return "NewCriterion in method: " + this.methodName + " at location " + this.loc;
    }
}

