/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Locale;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.find.InClassCriterion;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

final class IsCriterion
implements Criterion {
    private final Tree.Kind kind;
    private final String name;

    IsCriterion(Tree.Kind kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.HAS_KIND;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Tree tree = path.getLeaf();
        if (TreePathUtil.hasClassKind(tree)) {
            return InClassCriterion.isSatisfiedBy(path, this.name, true);
        }
        if (tree.getKind() != this.kind) {
            return false;
        }
        switch (tree.getKind()) {
            case VARIABLE: {
                String varName = ((VariableTree)tree).getName().toString();
                return varName.equals(this.name);
            }
            case METHOD: {
                String methodName = ((MethodTree)tree).getName().toString();
                return methodName.equals(this.name);
            }
        }
        throw new Error("unknown tree kind " + (Object)((Object)this.kind));
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    public String toString() {
        return "is " + this.kind.toString().toLowerCase(Locale.getDefault()) + " '" + this.name + "'";
    }
}

