/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

public class InFieldInitCriterion
implements Criterion {
    public final String varName;
    public final Criterion varCriterion;

    public InFieldInitCriterion(String varName) {
        this.varName = varName;
        this.varCriterion = Criteria.is(Tree.Kind.VARIABLE, varName);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        while (path != null) {
            if (TreePathUtil.isFieldInit(path)) {
                return this.varCriterion.isSatisfiedBy(path);
            }
            path = path.getParentPath();
        }
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_FIELD_INIT;
    }

    public String toString() {
        return "In field initializer for field '" + this.varName + "'";
    }
}

