/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.TypeKind;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.find.TreeFinder;
import org.checkerframework.afu.scenelib.el.TypePathEntry;
import org.objectweb.asm.TypePath;

public class GenericArrayLocationCriterion
implements Criterion {
    private static final boolean debug = false;
    private final List<TypePathEntry> location;
    private final TypePath typePath;

    public GenericArrayLocationCriterion() {
        this(null, null);
    }

    public GenericArrayLocationCriterion(TypePath typePath) {
        this(typePath, TypePathEntry.typePathToList(typePath));
    }

    public GenericArrayLocationCriterion(List<TypePathEntry> location) {
        this.location = location;
        this.typePath = TypePathEntry.listToTypePath(location);
    }

    private GenericArrayLocationCriterion(TypePath typePath, List<TypePathEntry> location) {
        this.typePath = typePath;
        this.location = location;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    private boolean containsOnlyArray(List<TypePathEntry> location) {
        for (TypePathEntry tpe : location) {
            if (tpe.step == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        Tree parent;
        TreePath parentPath;
        if (path == null || path.getParentPath() == null) {
            return false;
        }
        TreePath pathRemaining = path;
        Tree leaf = path.getLeaf();
        Tree child = null;
        if (leaf.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            child = ((ParameterizedTypeTree)leaf).getType();
        } else if (leaf.getKind() == Tree.Kind.VARIABLE) {
            child = ((VariableTree)leaf).getType();
        } else if (leaf.getKind() == Tree.Kind.NEW_CLASS) {
            child = ((NewClassTree)leaf).getIdentifier();
        } else if (leaf.getKind() == Tree.Kind.NEW_ARRAY && this.typePath != null) {
            child = ((NewArrayTree)leaf).getType();
        }
        if (child != null && child.getKind() == Tree.Kind.MEMBER_SELECT) {
            JCTree.JCExpression exp = ((JCTree.JCFieldAccess)child).getExpression();
            if (exp.type != null && exp.type.getKind() == TypeKind.PACKAGE || this.typePath == null || this.typePath.getStep(this.typePath.getLength() - 1) != 1) {
                return false;
            }
        }
        if (leaf.getKind() == Tree.Kind.MEMBER_SELECT) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)leaf;
            if (this.isStatic(fieldAccess)) {
                if (this.typePath == null) {
                    return true;
                }
                if (this.isGenericOrArray(path.getParentPath().getLeaf()) && this.isGenericOrArray(path.getParentPath().getParentPath().getLeaf())) {
                    pathRemaining = path.getParentPath();
                }
            } else {
                JCTree.JCExpression exp = fieldAccess.getExpression();
                if (exp.getKind() == Tree.Kind.MEMBER_SELECT && exp.type != null && exp.type.getKind() == TypeKind.PACKAGE) {
                    if (this.typePath == null) {
                        return true;
                    }
                } else if (this.typePath != null && this.typePath.getStep(this.typePath.getLength() - 1) != 1) {
                    return false;
                }
            }
        }
        if (this.typePath == null) {
            leaf = path.getLeaf();
            Tree parent2 = path.getParentPath().getLeaf();
            boolean result = leaf.getKind() == Tree.Kind.NEW_ARRAY || leaf.getKind() == Tree.Kind.NEW_CLASS || leaf.getKind() == Tree.Kind.ANNOTATED_TYPE && this.isSatisfiedBy(TreePath.getPath(path, (Tree)((AnnotatedTypeTree)leaf).getUnderlyingType())) || (this.isGenericOrArray(leaf) || leaf.getKind() == Tree.Kind.IDENTIFIER || leaf.getKind() == Tree.Kind.METHOD || leaf.getKind() == Tree.Kind.TYPE_PARAMETER || leaf.getKind() == Tree.Kind.PRIMITIVE_TYPE) && !this.isGenericOrArray(parent2);
            return result;
        }
        while (pathRemaining.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            pathRemaining = pathRemaining.getParentPath();
        }
        ArrayList<TypePathEntry> locationRemaining = new ArrayList<TypePathEntry>(this.location);
        while (locationRemaining.size() != 0) {
            leaf = pathRemaining.getLeaf();
            if (leaf.getKind() == Tree.Kind.NEW_ARRAY && this.containsOnlyArray(locationRemaining)) {
                return true;
            }
            parentPath = pathRemaining.getParentPath();
            if (parentPath == null) {
                return false;
            }
            parent = parentPath.getLeaf();
            if (parent.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                parentPath = parentPath.getParentPath();
                parent = parentPath.getLeaf();
            }
            TypePathEntry loc = (TypePathEntry)locationRemaining.get(locationRemaining.size() - 1);
            if (loc.step == 1) {
                if (leaf.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    leaf = parent;
                    parentPath = parentPath.getParentPath();
                    parent = parentPath.getLeaf();
                }
                if (leaf.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)leaf;
                if (this.isStatic(fieldAccess)) {
                    return false;
                }
                locationRemaining.remove(locationRemaining.size() - 1);
                leaf = fieldAccess.selected;
                pathRemaining = parentPath;
                continue;
            }
            if (loc.step == 2 && leaf.getKind() == Tree.Kind.UNBOUNDED_WILDCARD) {
                if (locationRemaining.size() == 0) {
                    return false;
                }
                TreePath gpath = parentPath.getParentPath();
                if (gpath != null) {
                    Tree gparent = gpath.getLeaf();
                    if (gparent.getKind() == Tree.Kind.INSTANCE_OF) {
                        TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in 'instanceof' expression; skipping insertion%n", new Object[0]);
                        return false;
                    }
                    if (gparent.getKind() == Tree.Kind.PARAMETERIZED_TYPE && (gpath = gpath.getParentPath()) != null && gpath.getLeaf().getKind() == Tree.Kind.ARRAY_TYPE) {
                        TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in generic array type; skipping insertion%n", new Object[0]);
                        return false;
                    }
                }
                locationRemaining.remove(locationRemaining.size() - 1);
                continue;
            }
            if (parent.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                if (loc.step != 3) {
                    return false;
                }
                Tree inner = ((ParameterizedTypeTree)parent).getType();
                int i = locationRemaining.size() - 1;
                locationRemaining.remove(i--);
                while (inner.getKind() == Tree.Kind.MEMBER_SELECT && !this.isStatic((JCTree.JCFieldAccess)inner) && i >= 0) {
                    if (((TypePathEntry)locationRemaining.get((int)i)).step != 1) {
                        return false;
                    }
                    locationRemaining.remove(i--);
                    inner = ((MemberSelectTree)inner).getExpression();
                    if (inner.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                        inner = ((AnnotatedTypeTree)inner).getUnderlyingType();
                    }
                    if (inner.getKind() != Tree.Kind.PARAMETERIZED_TYPE) continue;
                    inner = ((ParameterizedTypeTree)inner).getType();
                }
                if (i >= 0 && ((TypePathEntry)locationRemaining.get((int)i)).step == 1) {
                    return false;
                }
                List<? extends Tree> childTrees = ((ParameterizedTypeTree)parent).getTypeArguments();
                boolean found = false;
                if (childTrees.size() > loc.argument) {
                    Tree childi = childTrees.get(loc.argument);
                    if (childi.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                        childi = ((AnnotatedTypeTree)childi).getUnderlyingType();
                    }
                    if (childi == leaf) {
                        TreePath outerPath = parentPath.getParentPath();
                        while (outerPath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT && !this.isStatic((JCTree.JCFieldAccess)outerPath.getLeaf())) {
                            if ((outerPath = outerPath.getParentPath()).getLeaf().getKind() == Tree.Kind.ANNOTATED_TYPE) {
                                outerPath = outerPath.getParentPath();
                            }
                            if (outerPath.getLeaf().getKind() != Tree.Kind.PARAMETERIZED_TYPE) break;
                            parentPath = outerPath;
                            outerPath = outerPath.getParentPath();
                        }
                        pathRemaining = parentPath;
                        found = true;
                    }
                }
                if (found) continue;
                return false;
            }
            if (parent.getKind() == Tree.Kind.EXTENDS_WILDCARD || parent.getKind() == Tree.Kind.SUPER_WILDCARD) {
                if (loc.step != 2 || locationRemaining.size() == 1) {
                    return false;
                }
                locationRemaining.remove(locationRemaining.size() - 1);
                WildcardTree wct = (WildcardTree)parent;
                Tree boundTree = wct.getBound();
                if (boundTree.equals(leaf)) {
                    if (locationRemaining.isEmpty()) {
                        return true;
                    }
                    pathRemaining = parentPath;
                    continue;
                }
                return false;
            }
            if (parent.getKind() == Tree.Kind.ARRAY_TYPE) {
                if (loc.step != 0) {
                    return false;
                }
                locationRemaining.remove(locationRemaining.size() - 1);
                parentPath = TreeFinder.largestContainingArray(parentPath);
                parent = parentPath.getLeaf();
                Tree elt = ((ArrayTypeTree)parent).getType();
                while (locationRemaining.size() > 0 && ((TypePathEntry)locationRemaining.get((int)(locationRemaining.size() - 1))).step == 0) {
                    if (elt.getKind() != Tree.Kind.ARRAY_TYPE) {
                        return false;
                    }
                    elt = ((ArrayTypeTree)elt).getType();
                    locationRemaining.remove(locationRemaining.size() - 1);
                }
                boolean b = elt.equals(leaf);
                if (b) {
                    pathRemaining = parentPath;
                    continue;
                }
                return false;
            }
            if (parent.getKind() == Tree.Kind.NEW_ARRAY) {
                return loc.step == 0;
            }
            return false;
        }
        parentPath = pathRemaining.getParentPath();
        if (parentPath == null) {
            return false;
        }
        parent = pathRemaining.getParentPath().getLeaf();
        return !this.isGenericOrArray(parent);
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    private boolean isStatic(JCTree.JCFieldAccess fieldAccess) {
        return fieldAccess.type != null && fieldAccess.type.getKind() == TypeKind.DECLARED && fieldAccess.type.tsym.isStatic();
    }

    private boolean isGenericOrArray(Tree t) {
        return t.getKind() == Tree.Kind.PARAMETERIZED_TYPE || t.getKind() == Tree.Kind.ARRAY_TYPE || t.getKind() == Tree.Kind.EXTENDS_WILDCARD || t.getKind() == Tree.Kind.SUPER_WILDCARD || t.getKind() == Tree.Kind.ANNOTATED_TYPE && this.isGenericOrArray(((AnnotatedTypeTree)t).getUnderlyingType());
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.GENERIC_ARRAY_LOCATION;
    }

    public String toString() {
        return "GenericArrayLocationCriterion at " + (this.typePath == null ? "outermost type" : "( " + this.typePath.toString() + " )");
    }

    public List<TypePathEntry> getLocation() {
        return this.location == null ? Collections.emptyList() : Collections.unmodifiableList(this.location);
    }
}

