/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.MethodCallScanner;
import org.checkerframework.afu.scenelib.el.RelativeLocation;

public class CallCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public CallCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName;
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        if (leaf.getKind() == Tree.Kind.METHOD_INVOCATION) {
            int indexInClass;
            int indexInSource = MethodCallScanner.indexOfMethodCallTree(path, leaf);
            boolean b = this.loc.isBytecodeOffset() ? indexInSource == (indexInClass = MethodCallScanner.getMethodCallIndex(this.methodName, this.loc.offset).intValue()) : indexInSource == this.loc.index;
            return b;
        }
        boolean b = this.isSatisfiedBy(path.getParentPath());
        return b;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.METHOD_CALL;
    }

    public String toString() {
        return "CallCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

